'use server'

import * as Z from "zod"
import { loginSchema } from "@/schemas";
import { signIn } from "@/auth";


export const login = async (values: Z.infer<typeof loginSchema>) => {
    const validatedFields = loginSchema.safeParse(values);

    if(!validatedFields.success){
        return { error: "Invalid fields!"}
    }
    
    const { email, password } = validatedFields.data

    try {
        const res = await signIn("credentials", {
            email: email,
            password: password,
            redirect: false,
        })
        return { success: true }    
    } catch (error) {
        return { error: 'Invalid Credentials'}
    }
}