'use server'

import { auth } from "@/auth";
import axios from "axios";

export const getCalendar = async () => {
    try {
        console.log('Get calender Lagi')
        const session = await auth()

        if(session){

            const calendarData  = await axios.get(`https://dash.bahasahospitality.com/api/v2/getCalendar`,
                {
                    headers: {
                        'Authorization': `Bearer ${session.accessToken}`,
                        'Accept': 'application/json'
                    }
                }
            );

            if (!calendarData) throw Error;

            return calendarData.data;
        }else{
            return { success: false }
        }
    } catch (error) {
        console.log(error)
    }
}
