'use server'

import { auth } from "@/auth";
import axios from "axios";

export const getDash = async () => {
    try {
        console.log('Get Dashboard Lagi')
        const session = await auth()

        const room_id = session?.user?.user.villa[0].room_id
        if(session){

            const dashData  = await axios.post(
                'https://dash.bahasahospitality.com/api/v2/getDashboardV2',
                {
                    roomId: room_id
                },
                {
                    headers: {
                        'Authorization': `Bearer ${session.accessToken}`,
                        'Accept': 'application/json'
                    }
                }
            );
            if (!dashData) throw Error;
            return dashData.data;
        }else{
            return { success: false }
        }
    } catch (error) {
        console.log(error)
    }
}