'use server'

import { auth } from "@/auth";
import axios from "axios";

export const deleteWhatsapp = async (id: any) => {
    
    try {
        const session = await auth()
        if(session){

            const currentAccount  = await axios.post(
                'https://dash.bahasahospitality.com/api/v2/notif/whatsapp/delete',
                {
                    id: id,
                },
                {
                    headers: {
                        'Authorization': `Bearer ${session.accessToken}`,
                        'Accept': 'application/json'
                    }
                }
            );
            if (!currentAccount) throw Error;
            return currentAccount.data;
        }else{
            return { success: false , message: 'Unauthenticated'} 
        }
    } catch (error) {
        console.log(error)
    }
}