import UserAuthForm from '@/components/auth/user-auth-form'
import ClientOnly from '@/components/web/client-only'
import { Metadata } from 'next'
import Image from 'next/image'
import Link from 'next/link'

export const metadata: Metadata = {
    title: 'Login | Dashboard Bali Management Villas',
    description: 'The Dashboard Owner by Bali Management Villas',
    robots: {
        index: false,
        follow: false,
    },
    icons: {
        icon: '/bmv-favicon.png',
        shortcut: '/bmv-favicon.png',
        apple: '/bmv-favicon.png',
        other: {
            rel: 'apple-touch-icon-precomposed',
            url: '/bmv-favicon.png',
        },
    },
    metadataBase: new URL('https://dash.balimanagement.villas'),
    alternates: {
        canonical: '/',
        languages: {
            'en-US': '/',
            'de-DE': '/de-DE',
            'id-ID': '/id-ID'
        },
    },
    openGraph: {
        images: '/og-picture.png',
    },
}

export default function Home() {
    return(
        <ClientOnly>
            <main className="container relative min-h-screen flex-col items-center justify-center grid lg:max-w-none lg:grid-cols-2 lg:px-0">
                <div className="relative h-full hidden flex-col bg-muted p-10 text-white lg:flex dark:border-r">
                    <div className="absolute inset-0 " style={{ background: 'url(/bg/bg-welcome.png)'}}/>
                    <div className="relative z-20 flex flex-col items-center justify-center h-full w-80 mx-auto text-lg  text-black dark:text-white">
                        <div className="space-y-6">
                            <Image
                                src="/bmv-logo.svg"
                                width={300}
                                height={140}
                                alt="Authentication"
                            />
                            <p className="text-3xl text-gray-500 font-medium">
                                A few more clicks to sign in to your account.
                            </p>
                            <p className="text-sm text-muted-foreground">
                                A few more clicks to sign in to your account.
                            </p>
                        </div>
                    </div>
                </div>
                <div className="lg:p-8">
                    <div className="mx-auto flex w-full flex-col justify-center space-y-6 sm:w-80">
                        <div className="lg:hidden flex items-center justify-center">
                            <Image
                                src="/bmv-logo.svg"
                                width={300}
                                height={140}
                                alt="Authentication"
                            />
                        </div>
                        <div className="flex flex-col space-y-2 text-center">
                            <h1 className="text-2xl font-semibold tracking-tight">
                            Sign in to your account
                            </h1>
                            <p className="text-sm text-muted-foreground">
                            Enter your email and password below
                            </p>
                        </div>
                        <UserAuthForm />
                        
                    </div>
                </div>
            </main>
        </ClientOnly>
    )
}