'use client'

import { compareDesc, format, parseISO } from "date-fns";
import { columns } from "./coloumn";
import { DataTable } from "./data-table";
import { useState } from "react";
import { Dialog, DialogContent, DialogDescription, DialogHeader, DialogTitle } from "@/components/ui/dialog";
import Image from "next/image";


interface Props{
    data: any;
    selected: any;
}
const AllBooking = ({data, selected}: Props) => {
    const [open, setOpen] = useState(false)
    const [selectedItem, setselectedItem] = useState<any>(null)
    
    const roomData = data.filter((item: any) => item.resourceId === selected.room_id);
    const sortedData = roomData.sort((a: any, b: any) => compareDesc(parseISO(a.start), parseISO(b.start)));

    const onClick = (value: any) => {
        setOpen(!open)
        setselectedItem(value)
    }
    return (
        <div>
            <DataTable columns={columns} data={sortedData} onClick={onClick} loading={false}/>
            <Dialog open={open} onOpenChange={setOpen} defaultOpen={false}>
                <DialogContent>
                    <DialogHeader className='sr-only'>
                        <DialogTitle>Are you absolutely sure?</DialogTitle>
                        <DialogDescription>
                            Description
                        </DialogDescription>
                    </DialogHeader>
                    {selectedItem && (
                        <div className="lg:h-[320px] min-h-[40vh] space-y-3 overflow-y-auto overflow-x-hidden py-3 mt-6">
                            <div className="flex justify-between items-center">
                                <p className="px-3 py-2.5 rounded-full" style={{ backgroundColor: `${selectedItem.backgroundColor}`, color: `${selectedItem.textColor}` }}>#{selectedItem.id}</p>
                                <Image 
                                    src={selectedItem.channel}
                                    width={56}
                                    height={56}
                                    alt={selectedItem.channelname}
                                />
                            </div>
                            <div className="flex justify-center w-full">
                                <div className="flex-1 justify-center items-center w-1/2 border border-gray-200 dark:border-border rounded-l-xl p-3">
                                    <p className='text-sm'>Check-in :</p>
                                    <p className="font-semibold">{format(new Date(selectedItem.start), 'MMM dd, yyyy')}</p>
                                </div>
                                <div className="flex-1 justify-center items-center w-1/2 border border-gray-200 dark:border-border rounded-r-xl p-3">
                                    <p className='text-sm'>Check-out :</p>
                                    <p className="font-semibold">{format(new Date(selectedItem.end), 'MMM dd, yyyy')}</p>
                                </div>
                            </div>
                            <div className="space-y-3 border border-gray-200 dark:border-border rounded-xl p-3">
                                <div className="flex justify-between">
                                    <div className="flex-1">
                                        <p className="font-semibold">Name :</p>
                                        <p>{selectedItem.title}</p>
                                    </div>
                                    <div className="flex-1 justify-center items-center">
                                        <p className="font-semibold">Channel :</p>
                                        <p>{selectedItem.channelname}</p>
                                    </div>
                                </div>
                                {selectedItem.isEmail && (
                                    <div className="flex-1">
                                        <p className="font-semibold">Email :</p>
                                        <p>{selectedItem.email}</p>
                                    </div>
                                )}
                                <div className="flex-1">
                                    <p className="font-semibold">Guest :</p>
                                    <p>
                                        {selectedItem.adult} {selectedItem.adult > 1 ? 'Adults' : 'Adult'}
                                        {selectedItem.child > 0 && (
                                            selectedItem.adult > 0 
                                            ? `, ${selectedItem.child} ${selectedItem.child > 1 ? 'Children' : 'Child'}` 
                                            : ''
                                        )}
                                    </p>
                                </div>
                                {selectedItem.isPhone && (
                                    <div className="flex-1">
                                        <p className="font-semibold">Phone :</p>
                                        <p>{selectedItem.phone}</p>
                                    </div>
                                )}
                            </div>
                            {selectedItem.isNotes &&(
                                <div className="space-y-3 border border-gray-200 dark:border-border rounded-xl p-3">
                                    <p className="font-semibold">Notes :</p>
                                    <p className="border rounded-lg min-h-20 w-full border-gray-500 p-5 bg-gray-50 dark:bg-background dark:text-primary-foreground">{selectedItem.notes}</p>
                                </div>
                            )}
                            <div className='flex justify-between items-center w-full px-3 py-2.5 rounded-3xl font-semibold' style={{ backgroundColor: selectedItem.backgroundColor, color: selectedItem.textColor}}>
                                <p>Total price : </p>
                                <p>{selectedItem.price}</p>
                            </div>
                        </div>
                    )}
                </DialogContent>
            </Dialog>
        </div>
    )
}

export default AllBooking