'use client'
import React, { useState } from 'react';
import { addMonths, differenceInDays, eachDayOfInterval, endOfMonth, format, isPast, isSameMonth, isToday, isWeekend, isWithinInterval, startOfMonth } from 'date-fns';
import { Button } from '@/components/ui/button';
import { ChevronLeft, ChevronRight } from 'lucide-react';
import {
    Popover,
    PopoverContent,
    PopoverTrigger,
} from "@/components/ui/popover"
import Image from 'next/image';
import {
    Dialog,
    DialogContent,
    DialogDescription,
    DialogHeader,
    DialogTitle,
    DialogTrigger,
} from "@/components/ui/dialog"
import {
    Select,
    SelectContent,
    SelectItem,
    SelectTrigger,
    SelectValue,
} from "@/components/ui/select"

import { PopoverClose } from '@radix-ui/react-popover';
import { Card, CardContent, CardHeader } from '@/components/ui/card';

import { BsFillHouseFill } from "react-icons/bs";
import CockpitMetric from './cockpit-metric';

interface Props {
    event: any;
    villa: any;
    metrics: any;
    live: any;
}
const CockpitCalendar = ({ event, villa, metrics, live }: Props) => {
    const [liveData, setLiveData] = useState<any>(live)
    const [metricData, setMetricData] = useState<any>(metrics)
    const [bookings, setBookings] = useState<any>(event)
    const [resource, setResource] = useState<any>(villa)
    const [currentDate, setCurrentDate] = useState(new Date());
    const [numMonths, setNumMonths] = useState(1);
    const [open, setOpen] = useState(false);
    const [selected, setSelected] = useState<any>(null);
    const [vName,  setVName] = useState(false)
    const start = startOfMonth(currentDate);
    const end = endOfMonth(addMonths(currentDate, numMonths - 1));
    const allDates = eachDayOfInterval({ start, end });

    const handleNumMonthsChange = (e: any) => {       
        setBookings([])
        setResource([])
        setNumMonths(parseInt(e));
        setBookings(event)
        setResource(villa)
    };

    const handlePrevMonth = () => {
        setCurrentDate(prevDate => addMonths(prevDate, -numMonths));
    };

    const handleNextMonth = () => {
        setCurrentDate(prevDate => addMonths(prevDate, numMonths));
    };

    const getHeader = () => {
        if (numMonths === 1) {
            return format(currentDate, 'MMMM yyyy');
        } else {
            const startMonth = format(currentDate, 'MMMM');
            const startYear = format(currentDate, 'yyyy');
            const endMonth = format(addMonths(currentDate, numMonths - 1), 'MMMM');
            const endYear = format(addMonths(currentDate, numMonths - 1), 'yyyy');
            return `${startMonth} ${startYear} - ${endMonth} ${endYear}`;
        }
    };

    const renderCalendar = () => {
        let monthGroups = [];
        let currentMonth = startOfMonth(allDates[0]);
        let monthDates: Date[] = [];

        allDates.forEach(date => {
            if (!isSameMonth(date, currentMonth)) {
                monthGroups.push({ month: format(currentMonth, 'MMMM yyyy'), dates: monthDates });
                currentMonth = startOfMonth(date);
                monthDates = [];
            }
            monthDates.push(date);
        });

        monthGroups.push({ month: format(currentMonth, 'MMMM yyyy'), dates: monthDates });

        return monthGroups.map(group => (
            <div key={group.month}>
                <div className='px-2 py-1.5 border h-14'>
                    <div className='sticky lg:left-[40%] left-[15%] max-w-60 line-clamp-1 border rounded-lg p-2 bg-white flex items-center justify-center drop-shadow-lg'>
                        <h2 className="text-center font-bold uppercase">{group.month}</h2>
                    </div>
                </div>
                <div className='space-y-3'>
                    {resource.length > 0 ? (
                        resource.map((res: any) => (
                            <div key={res.id} className="flex flex-col">
                                <div className='px-2 py-1.5 border h-[4.5rem]'>
                                    <div id='live-6' className='sticky left-2 lg:left-5 max-w-72 line-clamp-1 border rounded-lg p-2 bg-white flex items-center justify-between drop-shadow-lg'>
                                        <Popover defaultOpen={true}>
                                            <PopoverTrigger asChild>
                                                <div className='flex items-center cursor-pointer'>
                                                    <BsFillHouseFill className='mr-2 h-5 w-5'/>
                                                    <h3 className="font-semibold line-clamp-1">{res.label}</h3>
                                                </div>
                                            </PopoverTrigger>
                                        <PopoverContent className='w-full min-w-40 bg-black/50 p-2'>
                                        <span className='text-white'>{res.label}</span></PopoverContent>
                                        </Popover>

                                        <CockpitMetric data={res} metrics={metrics} live={live}/>
                                    </div>
                                </div>
                                <div className='flex flex-nowrap overflow-x-auto max-w-container h-12'>
                                    {group.dates.map((date, idx) => (
                                        <div
                                            key={idx}
                                            className={`p-2 w-[60px] text-center border ${isToday(date) ? 'font-bold bg-[#f38f59] text-white' : isPast(date) ? 'bg-gray-100 text-gray-500' : '' } ${isWeekend(date) ? 'bg-gray-200 text-gray-600 border-white' : '' }`}
                                        >
                                            <div>
                                                <div className="text-xs">{format(date, 'eee')}</div>
                                                <div className="text-sm font-semibold">{format(date, 'dd')}</div>
                                            </div>
                                        </div>
                                    ))}
                                </div>
                                <div className='flex flex-nowrap max-w-container h-12 relative'>
                                    {group.dates.map((date, idx) => (
                                        <div key={idx} className={`p-2 w-[60px] text-center border ${isToday(date) ? 'font-bold bg-[#f38f59] text-white' : isPast(date) ? 'font-bold bg-gray-100' : ''}`}></div>
                                    ))}
                                    {bookings.filter((booking: any) => booking.resourceId === res.id).map((booking: any, index: any) => {
                                        const startDate = new Date(booking.start);
                                        const endDate = new Date(booking.end);
                                        const firstDateOfMonth = group.dates[0];
                                        const lastDateOfMonth = group.dates[group.dates.length - 1];
    
                                        const isStartWithinMonth = isWithinInterval(startDate, { start: firstDateOfMonth, end: lastDateOfMonth });
                                        const isEndWithinMonth = isWithinInterval(endDate, { start: firstDateOfMonth, end: lastDateOfMonth });
                                        const isSpanningAcrossMonths = startDate < firstDateOfMonth && endDate > lastDateOfMonth;
    
                                        if (isStartWithinMonth || isEndWithinMonth || isSpanningAcrossMonths) {
                                            const startOffset = startDate < firstDateOfMonth ? 0 : differenceInDays(startDate, firstDateOfMonth) + 0.5;
                                            const endOffset = endDate > lastDateOfMonth ? group.dates.length : differenceInDays(endDate, firstDateOfMonth) + 0.5;
                                            const width = (endOffset - startOffset) * 60;
    
                                            const borderRadiusStyle = {
                                                borderRadius: `${startDate < firstDateOfMonth ? 0 : 10}px ${endDate > lastDateOfMonth ? 0 : 10}px ${endDate > lastDateOfMonth ? 0 : 10}px ${startDate < firstDateOfMonth ? 0 : 10}px`,
                                            };
    
                                            return (
                                                <Popover key={index}>
                                                    <PopoverTrigger asChild>
                                                        <div
                                                            className={`absolute top-1.5 h-10 bg-blue-500 text-white flex items-center justify-center border drop-shadow-lg cursor-pointer`}
                                                            style={{
                                                                backgroundColor: `${booking.backgroundColor || 'blue'}`,
                                                                borderColor: booking.textColor,
                                                                left: `${startOffset * 60}px`,
                                                                width: `${width}px`,
                                                                zIndex: 1,
                                                                ...borderRadiusStyle,
                                                            }}
                                                        >
                                                            <div className="absolute top-0 h-full flex items-center justify-center" style={{ color: booking.textColor }}>
                                                                {booking.channel ?  (
                                                                    <Image src={booking.channel} alt='booking' width={36} height={36} />
                                                                ): (
                                                                    <span className='text-xs'>{booking.channelname}</span>
                                                                )}
                                                                
                                                            </div>
                                                        </div>
                                                    </PopoverTrigger>
                                                    <PopoverContent className=' p-0 min-w-[8rem] rounded-xl drop-shadow-2xl'>
                                                        <div className='p-2.5 bg-gray-300 rounded-t-xl'>
                                                            <p className='text-center text-sm font-semibold'>Booking Details</p>
                                                        </div>
                                                        <div className='w-full' style={{ backgroundColor: booking.backgroundColor}}>
                                                            <p className='text-center text-sm py-1.5' style={{ color: booking.textColor }}>{booking.channelname}</p>
                                                        </div>
                                                        <div className='space-y-3 p-2.5'>
                                                            <div className="bg-white space-y-2">
                                                                <div className="flex w-full items-stretch gap-2">
                                                                    <div className="shrink-0 flex items-center">
                                                                        <Image src='/icons/check-in.svg' alt='checkin' width={14} height={14} />
                                                                    </div>
                                                                    <div className="flex flex-1 justify-between items-center gap-2">
                                                                        <div className="grid gap-1.5">
                                                                            <span className="text-sm">
                                                                                Checkin Date :
                                                                            </span>
                                                                        </div>
                                                                        <span className="font-medium text-foreground text-sm">
                                                                            {format(new Date(booking.start), 'MMM dd, yyyy')}
                                                                        </span>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div className="bg-white space-y-2">
                                                                <div className="flex w-full items-stretch gap-2">
                                                                    <div className="shrink-0 flex items-center">
                                                                        <Image src='/icons/check-out.svg' alt='checkout' width={14} height={14} />
                                                                    </div>
                                                                    <div className="flex flex-1 justify-between items-center gap-2">
                                                                        <div className="grid gap-1.5">
                                                                            <span className="text-sm">
                                                                                Checkout Date :
                                                                            </span>
                                                                        </div>
                                                                        <span className="font-medium text-foreground text-sm">
                                                                            {format(new Date(booking.end), 'MMM dd, yyyy')}
                                                                        </span>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div className="bg-white space-y-2">
                                                                <div className="flex w-full items-stretch gap-2">
                                                                    <div className="shrink-0 flex items-center">
                                                                        <Image src='/icons/nights.svg' alt='nights' width={14} height={14} />
                                                                    </div>
                                                                    <div className="flex flex-1 justify-between items-center gap-2">
                                                                        <div className="grid gap-1.5">
                                                                            <span className="text-sm">
                                                                                Nights :
                                                                            </span>
                                                                        </div>
                                                                        <span className="font-medium text-foreground text-sm">
                                                                            {differenceInDays((new Date(booking.end)), (new Date(booking.start)))}
                                                                        </span>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div className="bg-white space-y-2">
                                                                <div className="flex w-full items-stretch gap-2">
                                                                    <div className="shrink-0 flex items-center">
                                                                        <Image src='/icons/price.svg' alt='nights' width={14} height={14} />
                                                                    </div>
                                                                    <div className="flex flex-1 justify-between items-center gap-2">
                                                                        <div className="grid gap-1.5">
                                                                            <span className="text-sm">
                                                                                Price :
                                                                            </span>
                                                                        </div>
                                                                        <span className="font-medium text-foreground text-sm">
                                                                            {booking.price}
                                                                        </span>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div className='grid grid-cols-2'>
                                                            <PopoverClose asChild>
                                                                <div className='bg-red-500/90 w-full rounded-bl-xl p-2.5 cursor-pointer hover:bg-red-500'>
                                                                    <p className='text-center text-white text-sm'>Close</p>
                                                                </div>
                                                            </PopoverClose> 
                                                            <div className='bg-blue-500/90 w-full rounded-br-xl p-2.5 cursor-pointer hover:bg-blue-500' onClick={() => { setOpen(true), setSelected(booking) }}>
                                                                <p className='text-center text-white text-sm'>Details</p>
                                                            </div>
                                                        </div>
                                                    </PopoverContent>
                                                </Popover>
                                            );
                                        }
                                        return null;
                                    })}
                                </div>
                            </div>
                        ))
                    ):(
                        <div className="flex flex-col">
                            <div className='flex flex-nowrap overflow-x-auto max-w-container h-12'>
                                {group.dates.map((date, idx) => (
                                    <div
                                        key={idx}
                                        className={`p-2 w-[60px] text-center border ${isToday(date) ? 'font-bold bg-[#f38f59] text-white' : isPast(date) ? 'bg-gray-100 text-gray-500' : '' } ${isWeekend(date) ? 'bg-gray-200 text-gray-600 border-white' : '' }`}
                                    >
                                        <div>
                                            <div className="text-xs">{format(date, 'eee')}</div>
                                            <div className="text-sm font-semibold">{format(date, 'dd')}</div>
                                        </div>
                                    </div>
                                ))}
                            </div>
                            <div className='flex flex-nowrap max-w-container h-12 relative'>
                                {group.dates.map((date, idx) => (
                                    <div key={idx} className={`p-2 w-[60px] text-center border ${isToday(date) ? 'font-bold bg-[#f38f59] text-white' : isPast(date) ? 'font-bold bg-gray-100' : ''}`}></div>
                                ))}
                            </div>
                        </div>
                    )}
                </div>
            </div>
        ));
    };
    return (
        <div className="space-y-3 w-full">
            <Card>
                <CardHeader>
                    <div className="flex items-center justify-evenly gap-3 w-full">
                        <Button id='live-2' size='sm' onClick={handlePrevMonth}>
                            <ChevronLeft />
                        </Button>
                        <h1 id='live-3' className='uppercase font-bold'>
                            {getHeader()}
                        </h1>
                        <Select onValueChange={handleNumMonthsChange} defaultValue={String(numMonths)}>
                            <SelectTrigger id='live-4' className="w-[180px]">
                                <SelectValue placeholder="asdqw"/>
                            </SelectTrigger>
                            <SelectContent>
                                <SelectItem value="1">1 Month</SelectItem>
                                <SelectItem value="2">2 Month</SelectItem>
                                <SelectItem value="3">3 Month</SelectItem>
                                <SelectItem value="6">6 Month</SelectItem>
                                <SelectItem value="12">1 Year</SelectItem>
                            </SelectContent>
                        </Select>
                        <Button id='live-5' size='sm' onClick={handleNextMonth}>
                            <ChevronRight />
                        </Button>
                    </div>
                </CardHeader>
                <CardContent>
                    <div className="flex items-center h-full relative shadow-inner">
                        <div className="grow flex flex-nowrap overflow-x-auto lg:max-w-container w-full overflow-y-hidden h-auto pb-4 ">
                            {renderCalendar()}
                        </div>
                    </div>
                </CardContent>
            </Card>
            <Dialog open={open} onOpenChange={setOpen} defaultOpen={false}>
                <DialogContent>
                    <DialogHeader className='sr-only'>
                        <DialogTitle>Are you absolutely sure?</DialogTitle>
                        <DialogDescription>
                            Description
                        </DialogDescription>
                    </DialogHeader>
                    {selected && (
                        <div className="lg:h-[320px] min-h-[40vh] space-y-3 overflow-y-auto overflow-x-hidden py-3">
                            <div className="flex justify-between items-center">
                                <p className="px-3 py-2.5 rounded-full" style={{ backgroundColor: `${selected.backgroundColor}`, color: `${selected.textColor}` }}>#{selected.id}</p>
                                <Image 
                                    src={selected.channel}
                                    width={56}
                                    height={56}
                                    alt={selected.channelname}
                                />
                            </div>
                            <div className="flex justify-center w-full">
                                <div className="flex-1 justify-center items-center w-1/2 border border-gray-200 dark:border-border rounded-l-xl p-3">
                                    <p className='text-sm'>Check-in :</p>
                                    <p className="font-semibold">{format(new Date(selected.start), 'MMM dd, yyyy')}</p>
                                </div>
                                <div className="flex-1 justify-center items-center w-1/2 border border-gray-200 dark:border-border rounded-r-xl p-3">
                                    <p className='text-sm'>Check-out :</p>
                                    <p className="font-semibold">{format(new Date(selected.end), 'MMM dd, yyyy')}</p>
                                </div>
                            </div>
                            <div className="space-y-3 border border-gray-200 dark:border-border rounded-xl p-3">
                                <div className="flex justify-between">
                                    <div className="flex-1">
                                        <p className="font-semibold">Name :</p>
                                        <p>{selected.title}</p>
                                    </div>
                                    <div className="flex-1 justify-center items-center">
                                        <p className="font-semibold">Channel :</p>
                                        <p>{selected.channelname}</p>
                                    </div>
                                </div>
                                {selected.isEmail && (
                                    <div className="flex-1">
                                        <p className="font-semibold">Email :</p>
                                        <p>{selected.email}</p>
                                    </div>
                                )}
                                <div className="flex-1">
                                    <p className="font-semibold">Guest :</p>
                                    <p>
                                        {selected.adult} {selected.adult > 1 ? 'Adults' : 'Adult'}
                                        {selected.child > 0 && (
                                            selected.adult > 0 
                                            ? `, ${selected.child} ${selected.child > 1 ? 'Children' : 'Child'}` 
                                            : ''
                                        )}
                                    </p>
                                </div>
                                {selected.isPhone && (
                                    <div className="flex-1">
                                        <p className="font-semibold">Phone :</p>
                                        <p>{selected.phone}</p>
                                    </div>
                                )}
                            </div>
                            {selected.isNotes &&(
                                <div className="space-y-3 border border-gray-200 dark:border-border rounded-xl p-3">
                                    <p className="font-semibold">Notes :</p>
                                    <p className="border rounded-lg min-h-20 w-full border-gray-500 p-5 bg-gray-50 dark:bg-background dark:text-primary-foreground">{selected.notes}</p>
                                </div>
                            )}
                            <div className='flex justify-between items-center w-full px-3 py-2.5 rounded-3xl font-semibold' style={{ backgroundColor: selected.backgroundColor, color: selected.textColor}}>
                                <p>Total price : </p>
                                <p>{selected.price}</p>
                            </div>
                        </div>
                    )}
                </DialogContent>
            </Dialog>
        </div>
    )
}

export default CockpitCalendar