'use client'

import PopoverOcc from '@/components/popover/popover-occ';
import { Card, CardContent, CardHeader, CardTitle } from '@/components/ui/card';
import GaugeChart from 'react-gauge-chart'

interface Props {
    occ: any;
}
const CockpitGauge = ({occ}: Props) => {
    const percent = occ / 100
    return (
        <Card>
            <CardHeader>
                <div className='flex items-center justify-between'>
                    <CardTitle>Occupancy</CardTitle>
                    <PopoverOcc />
                </div>
            </CardHeader>
            <CardContent className='space-y-3'>
                    <div className='lg:w-full w-[150px] flex items-center justify-center mx-auto'>
                        <GaugeChart id="gauge-chart1"
                            percent={percent} 
                            colors={['#b5e5f9','#52bcec','#006ec1']}
                            hideText={true}
                        />
                    </div>
                    <p className='font-semibold text-center'>{occ.toFixed(2)} % occupied</p>
            </CardContent>
        </Card>
    )
}

export default CockpitGauge