"use client"

import { useState } from "react"
import { CartesianGrid, Line, LineChart, XAxis } from "recharts"

import {
    ChartConfig,
    ChartContainer,
    ChartTooltip,
    ChartTooltipContent,
} from "@/components/ui/chart"

const chartConfig = {
    revenue: {
        label: "Revenue",
        color: "hsl(var(--chart-1))",
    },
} satisfies ChartConfig

interface Props {
    data: any;
}
const CockpitChartYearlyRevenue = ({data}: Props) => {

    return (
        <ChartContainer
            config={chartConfig}
            className="lg:min-h-[300px] h-full w-full"
        >
            <LineChart
                accessibilityLayer
                data={data}
                margin={{
                    left: 12,
                    right: 12,
                }}
            >
            <CartesianGrid vertical={false} />
            <XAxis
                dataKey="months"
                tickLine={false}
                axisLine={false}
                tickMargin={8}
                minTickGap={32}
                tickFormatter={(value) => value.slice(0, 3)}
            />
            <ChartTooltip
                content={
                    <ChartTooltipContent
                        className="w-[150px]"
                        nameKey="revenue"
                    />
                }
            />
            <Line
                dataKey='revenue'
                type="linear"
                stroke='var(--color-revenue)'
                strokeWidth={2}
                dot={false}
            />
            </LineChart>
        </ChartContainer>
    )
}

export default CockpitChartYearlyRevenue