"use client"
import { TrendingUp } from "lucide-react"
import { Bar, BarChart, CartesianGrid, XAxis } from "recharts"

import {
    ChartConfig,
    ChartContainer,
    ChartTooltip,
    ChartTooltipContent,
} from "@/components/ui/chart"


const chartConfig = {
    booked: {
        label: "Total Booked",
        color: "hsl(var(--chart-1))",
    },
    nights: {
        label: "Total Nights",
        color: "hsl(var(--chart-2))",
    },
    occupancy: {
        label: "Occupancy Rates",
        color: "hsl(var(--chart-3))",
    },
    revenue: {
        label: "Revenue",
        color: "hsl(var(--chart-4))",
    },
} satisfies ChartConfig

interface Props {
    data: any
}
const CockpitChartYearly = ({data}: Props) => {

    const CustomTooltip = ({ active, payload, label, indicatorColor }: any) => {
        if (active && payload && payload.length) {
            return (
                <div className="bg-white border space-y-2 p-3 min-w-[8rem]">
                    <p className="font-semibold capitalize">{label}</p>
                    <div className="flex w-full items-stretch gap-2">
                        <div className="shrink-0 rounded-[2px] h-2.5 w-2.5 border-[#4CAF50] bg-[#4CAF50]"/>
                        <div className="flex flex-1 justify-between leading-none items-center gap-2">
                            <div className="grid gap-1.5">
                                <span className="text-muted-foreground">
                                    Booked
                                </span>
                            </div>
                            <span className="font-mono font-medium tabular-nums text-foreground">
                                {payload[0].value}
                            </span>
                        </div>
                    </div>
                    <div className="flex w-full items-stretch gap-2">
                        <div className="shrink-0 rounded-[2px] h-2.5 w-2.5 border-[#2196F3] bg-[#2196F3]"/>
                        <div className="flex flex-1 justify-between leading-none items-center gap-2">
                            <div className="grid gap-1.5">
                                <span className="text-muted-foreground">
                                    Nights
                                </span>
                            </div>
                            <span className="font-mono font-medium tabular-nums text-foreground">
                                {payload[1].value}
                            </span>
                        </div>
                    </div>
                    <div className="flex w-full items-stretch gap-2">
                        <div className="shrink-0 rounded-[2px] h-2.5 w-2.5 border-[#F44336] bg-[#F44336]"/>
                        <div className="flex flex-1 justify-between leading-none items-center gap-2">
                            <div className="grid gap-1.5">
                                <span className="text-muted-foreground">
                                Occupancy
                                </span>
                            </div>
                            <span className="font-mono font-medium tabular-nums text-foreground">
                                {payload[2].value} %
                            </span>
                        </div>
                    </div>
                </div>
            );
        }
    
        return null;
    };

    return (
        <ChartContainer config={chartConfig} className="lg:min-h-[300px] h-full w-full">
            <BarChart accessibilityLayer data={data}>
                <CartesianGrid vertical={false} />
                <XAxis
                    dataKey="months"
                    tickLine={false}
                    tickMargin={10}
                    axisLine={false}
                    tickFormatter={(value) => value.slice(0, 3)}
                />
                <ChartTooltip
                    cursor={false}
                    content={<CustomTooltip />}
                />
                <Bar dataKey="booked" fill="var(--color-booked)" radius={4} />
                <Bar dataKey="nights" fill="var(--color-nights)" radius={4} />
                <Bar dataKey="occupancy" fill="var(--color-occupancy)" radius={4} />
            </BarChart>
        </ChartContainer>
    )
}

export default CockpitChartYearly