'use client'

import { Button } from "@/components/ui/button"
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card";
import {
    Drawer,
    DrawerClose,
    DrawerContent,
    DrawerDescription,
    DrawerFooter,
    DrawerHeader,
    DrawerTitle,
    DrawerTrigger,
} from "@/components/ui/drawer"
import { ScrollArea } from "@/components/ui/scroll-area"

import { useMemo, useState } from "react";
import { IoClose } from "react-icons/io5";
import CockpitGauge from "./cockpit-chart-gauge";
import CockpitBookingSource from "./cockpit-chart-source";
import { Separator } from "@/components/ui/separator";
import CockpitChartYearly from "./cockpit-chart-yearly";
import CockpitChartYearlyRevenue from "./cockpit-chart-yearly-revenue";
import { getDaysInMonth } from "date-fns";

interface Props {
    data: any;
    metrics: any
    live: any
}
const CockpitMetric = ({data, metrics, live}: Props) => {
    const [month, setMonth] = useState(new Date().getMonth() + 1)

    const monthNames = useMemo(() => [
        { no: 1, name: 'January' },
        { no: 2, name: 'February' },
        { no: 3, name: 'March' },
        { no: 4, name: 'April' },
        { no: 5, name: 'May' },
        { no: 6, name: 'June' },
        { no: 7, name: 'July' },
        { no: 8, name: 'August' },
        { no: 9, name: 'September' },
        { no: 10, name: 'October' },
        { no: 11, name: 'November' },
        { no: 12, name: 'December' },
    ], []);

    const getMonthName = (monthNo: any) => {
        const month = monthNames.find((m) => m.no === monthNo);
        return month ? month.name : '';
    };

    const findMetricDataById = (metricsArray: any, id: any) => {
        return metricsArray ? metricsArray.find((metric: any) => data.id ? metric.id === data.id : true) : null;
    };

    const yearlyRev = findMetricDataById(metrics.yearly_revenue, data.id);
    const monthlyIdBooked = findMetricDataById(metrics.monthly_total_booked, data.id);
    const monthlyNightBooked = findMetricDataById(metrics.monthly_booked_nights, data.id);
    const monthlyOccupancy = findMetricDataById(metrics.monthly_occupancy, data.id);
    const monthlyRevenues = findMetricDataById(metrics.monthly_revenue, data.id);

    const monthlyLive = live.find((l: any) =>
        data.id ? l.villa_id === data.id : true
    );

    const monthDatas = monthlyIdBooked
    ? monthlyIdBooked.data.find((itemData: any) => itemData.month === month)
    : null;

    const monthlyNights = monthlyNightBooked
    ? monthlyNightBooked.data.find((itemData: any) => itemData.month === month)
    : null;
    

    const occupancyRates = monthlyOccupancy
    ? monthlyOccupancy.data.find((itemData: any) => itemData.month === month)
    : null;


    const monthlyRevenue = monthlyRevenues
    ? monthlyRevenues.data.find((itemData: any) => itemData.month === month)
    : null;

    const liveMonthly = monthlyLive
    ? monthlyLive.data.find((itemData: any) => itemData.month === month)
    : null;

    const mergedData = [];

    for (let month = 1; month <= 12; month++) {
        
        const booked = monthlyIdBooked.data.find((entry: any) => entry.month === month)?.value || 0;
        const nights = monthlyNightBooked.data.find((entry: any) => entry.month === month)?.value || 0;
        const occupancy = monthlyOccupancy.data.find((entry: any) => entry.month === month)?.value || 0;
        const revenue = monthlyRevenues.data.find((entry: any) => entry.month === month)?.value || 0;

        mergedData.push({
            months: getMonthName(month),
            booked,
            nights,
            occupancy,
            revenue
        });
    }

    const revenueData = [];
    for (let month = 1; month <= 12; month++) {
        const revenue = monthlyRevenues.data.find((entry: any) => entry.month === month)?.value || 0;
        revenueData.push({
            months: getMonthName(month),
            revenue
        });
    }
    const onAdd = () => {
        setMonth(month === 12 ? 1 : month + 1);
    };

    const onReduce = () => {
        setMonth(month === 1 ? 12 : month - 1);
    };

    const date = new Date(new Date().getFullYear(), month - 1);
    const totalDays = getDaysInMonth(date);
    return (
        <Drawer>
            <DrawerTrigger asChild>
                <Button id="live-7" className='h-10 drop-shadow-lg py-0'>
                    More Details
                </Button>
            </DrawerTrigger>
            <DrawerContent className="h-screen">
                <div className="max-w-[1140px] mx-auto">
                    <div className="relative">
                        <div className="absolute top-0 right-5">
                            <DrawerClose asChild>
                                <Button variant="outline">
                                    <IoClose />
                                </Button>
                            </DrawerClose>
                        </div>
                        <DrawerHeader className="px-6">
                            <DrawerTitle>{data.label}</DrawerTitle>
                            <DrawerDescription>The metrics data ( Monthly Revenue, Yearly Revenue, Occupancy Rates, Booking Source) </DrawerDescription>
                        </DrawerHeader>
                    </div>
                    <div className="space-y-3 px-6">
                        <div className="flex items-center justify-between lg:px-20">
                            <Button onClick={onReduce}>
                                Prev Month
                            </Button>
                            <p className="font-bold text-xl uppercase">{monthNames.find(m => m.no === month)?.name}</p>
                            <Button onClick={onAdd}>
                                Next Month
                            </Button>
                        </div>
                        <ScrollArea className="h-[80vh] w-full rounded-md p-4">
                            <div className="grid lg:grid-cols-3 gap-6">
                                <div className="space-y-6">
                                    <Card>
                                        <CardHeader>
                                            <CardTitle>Revenue</CardTitle>
                                        </CardHeader>
                                        <CardContent>
                                            <div className="space-y-1">
                                                <p className="text-lg font-bold leading-none sm:text-3xl">$ {monthlyRevenue.value.toLocaleString()}</p>
                                                <p className="text-sm">± Avg. Daily Rate ($ {(monthlyRevenue.value / totalDays).toLocaleString()})</p>
                                            </div>
                                        </CardContent>
                                    </Card>
                                    <Card>
                                        <CardHeader>
                                            <CardTitle>Details</CardTitle>
                                        </CardHeader>
                                        <CardContent>
                                            <div className="space-y-1">
                                                <p className="text-xl font-semibold">{monthlyNights.value} Nights Booked</p>
                                                <p className="text-sm">from {monthDatas.value} bookings</p>
                                            </div>
                                        </CardContent>
                                    </Card>
                                </div>
                                <CockpitGauge occ={occupancyRates.value}/>
                                <CockpitBookingSource data={liveMonthly.value} booked={monthDatas.value}/>
                            </div>
                            <Separator className="mt-6"/>
                            <div className="grid gap-6 mt-6 mb-12">
                                <Card>
                                    <CardHeader className="flex flex-col items-stretch space-y-0 border-b p-0 sm:flex-row">
                                        <div className="flex flex-1 flex-col justify-center gap-1 px-6 py-5 sm:py-6">
                                            <CardTitle>Yearly Revenue</CardTitle>
                                            <CardDescription>January - December {new Date().getFullYear()}</CardDescription>
                                        </div>
                                        <div className="flex">
                                            <div className="flex flex-1 flex-col justify-center gap-1 border-t px-6 py-4 text-left even:border-l data-[active=true]:bg-muted/50 sm:border-l sm:border-t-0 sm:px-8 sm:py-6">
                                                <span className="text-xs text-muted-foreground">
                                                    Yearly Revenue
                                                </span>
                                                <span className="text-lg font-bold leading-none sm:text-3xl">
                                                    $ {yearlyRev.revenue.toLocaleString()}
                                                </span>
                                            </div>
                                        </div>
                                    </CardHeader>
                                    <CardContent>
                                        <CockpitChartYearlyRevenue data={revenueData}/>
                                    </CardContent>
                                </Card>
                                <Card>
                                    <CardHeader>
                                        <CardTitle>Yearly Data</CardTitle>
                                        <CardDescription>January - December {new Date().getFullYear()}</CardDescription>
                                    </CardHeader>
                                    <CardContent>
                                        <CockpitChartYearly data={mergedData}/>
                                    </CardContent>
                                </Card>
                            </div>
                        </ScrollArea>
                    </div>
                </div>
            </DrawerContent>
        </Drawer>

    )
}

export default CockpitMetric