'use client'

import { format, getMonth } from "date-fns";

import { GoDotFill } from "react-icons/go";

import { Skeleton } from "@/components/ui/skeleton";

import CockpilotPopover from "@/components/popover/cockpilot-popover";
import CockpitCalendar from "@/components/dashboard/cockpit/cockpit-calendar";
import { Suspense } from "react";
import Loading from "@/components/web/loading";

interface Props {
    event: any;
    villa: any
    live: any; 
    metrics: any;
    isLoading: boolean;
}

const CockpitWrapper = ({event, villa, live, metrics, isLoading} : Props) => {
    const date = new Date();
    const month = getMonth(date)
    const formatedMonth = format(date, 'MMMM')
    return (
        <>
            <div className="flex items-center py-3">
                    {isLoading ? (
                        <Skeleton className="h-8 w-[160px] rounded-full" />
                    ) : (
                        <h3 id="live-1" className="text-xl font-semibold leading-none tracking-tight inline-flex">
                            <span className="text-[#4CAF50] mr-2"><GoDotFill /></span>
                            Live Data ( {formatedMonth} )
                        </h3>
                    )}
                <div className="ml-2">
                    <CockpilotPopover />
                </div>
            </div>
            <Suspense fallback={<Loading />}>
                <CockpitCalendar event={event} villa={villa} live={live} metrics={metrics}/>
            </Suspense>
        </>
    )
}

export default CockpitWrapper