'use client'

import { Suspense } from 'react';
import {useTranslations} from 'next-intl';
import { compareAsc, isAfter, parseISO } from "date-fns";

import {
    Card,
    CardContent,
    CardDescription,
    CardHeader,
    CardTitle,
} from "@/components/ui/card"
import { Skeleton } from "@/components/ui/skeleton";
import { TabsList, TabsTrigger } from '@/components/ui/tabs';
import { Button } from '@/components/ui/button';

import BookingOverview from '@/components/popover/booking-overview';
import { RecentBooking } from '@/components/dashboard/overview/recent-booking';
import Loading from '@/components/web/loading';

interface Props {
    booking: any
    isLoading: boolean;
    selected: any;
}
const BookingWrapper = ({isLoading, booking, selected}: Props) => {
    const t = useTranslations('Index');

    const filterRelevantDates = (data: any) => {
        const today = new Date();
        return data.filter((item: any) => {
            const startDate = parseISO(item.start);
            const endDate = parseISO(item.end);
            return isAfter(startDate, today) || (today >= startDate && today <= endDate);
        });
    }
    const futureEvents = filterRelevantDates(booking);
    const roomData = futureEvents.filter((item: any) => item.resourceId === selected.room_id);
    const sortedData = roomData.sort((a: any, b: any) => compareAsc(parseISO(a.start), parseISO(b.start)));
    const items = sortedData.slice(0, 10);
    return (
        <Card id='step-9' className="lg:col-span-3 drop-shadow-lg">
            <CardHeader>
                <div className="flex lg:flex-row flex-col gap-3">
                    <div className="flex-grow space-y-1">
                        <div className="flex items-center">
                            {isLoading ? (
                                <Skeleton className="h-6 min-w-[163px] rounded-full" />
                            ) : (
                                <CardTitle>{t('recentBooking')}</CardTitle>
                            )}
                            <div className="ml-2">
                                <BookingOverview />
                            </div>
                        </div>
                        {isLoading ? (
                            <Skeleton className="h-5 min-w-[163px] rounded-full" />
                        ) : (
                            <CardDescription>
                                {t('pb1')} {items && items.length} {t('pb2')}
                            </CardDescription>
                        )}
                    </div>
                    <div className="flex-shrink">
                        <TabsList className="bg-transparent">
                            <TabsTrigger value="bookings" className="flex items-center gap-x-1" asChild>
                                {isLoading ? (
                                    <Skeleton className="h-10 min-w-[76px] rounded-full" />
                                ) : (
                                    <Button>{t('viewAll')}</Button>
                                )}
                            </TabsTrigger>
                        </TabsList>
                    </div>
                </div>
            </CardHeader>
            <CardContent>
                <Suspense fallback={<Loading />}>
                    <RecentBooking data={items} loading={isLoading}/>
                </Suspense>
            </CardContent>
        </Card>
    )
}

export default BookingWrapper