'use client'

import {useTranslations} from 'next-intl';

import {
    Card,
    CardContent,
    CardDescription,
    CardHeader,
    CardTitle,
} from "@/components/ui/card"
import { Skeleton } from "@/components/ui/skeleton";

import ChartsOverview from '@/components/dashboard/overview/chart-overview';
import ChartOverview from '@/components/popover/chart-overview';


interface Props {
    dash: any;
    year: any;
    isLoading: boolean
    chart: any;
}
const ChartWrapper = ({dash, year, isLoading, chart}: Props) => {
    const t = useTranslations('Index');
    return (
        <Card id='step-8' className="lg:col-span-4 drop-shadow-lg">
            <CardHeader>
                <div className="flex items-center justify-between">
                    {isLoading ? (
                        <Skeleton className="h-6 min-w-[187px] rounded-full" />
                    ) : (
                        <CardTitle className='text-xl'>{t('overview')} {`( ${year} )`}</CardTitle>
                    )}
                    <ChartOverview />
                </div>
            </CardHeader>
            <CardContent className="pl-2 space-y-3">
                <div className="ml-4 grid grid-cols-1 lg:grid-cols-3 px-4 border rounded-lg">
                    <div className="p-5 flex lg:flex-col flex-row gap-1 justify-center items-center">
                        {isLoading ? (
                            <>
                                <Skeleton className="h-6 min-w-[110px] rounded-full" />
                                <Skeleton className="h-6 min-w-[74px] rounded-full" />
                            </>
                        ) : (
                            <>
                                <p>{t('totalRevenue')} :</p>
                                <p className="before:content-['$'] before:mr-2 font-bold text-[#4CAF50]">{dash ? dash.revenueSum.toLocaleString() : 0}</p>
                            </>
                        )}
                    </div>
                    <div className="lg:border-y-0 border-y lg:border-x p-5 flex lg:flex-col flex-row gap-1 justify-center items-center">
                        {isLoading ? (
                            <>
                                <Skeleton className="h-6 min-w-[110px] rounded-full" />
                                <Skeleton className="h-6 min-w-[74px] rounded-full" />
                            </>
                        ) : (
                            <>
                                <p>{t('totalProfit')} :</p>
                                <p className="before:content-['$'] before:mr-2 font-bold text-[#2196F3]">{dash ? dash.profitSum.toLocaleString() : 0}</p>
                            </>
                        )}
                    </div>
                    <div className="p-5 flex lg:flex-col flex-row gap-1 justify-center items-center">
                        {isLoading ? (
                            <>
                                <Skeleton className="h-6 min-w-[110px] rounded-full" />
                                <Skeleton className="h-6 min-w-[74px] rounded-full" />
                            </>
                        ) : (
                            <>
                                <p>{t('totalExpenses')} :</p>
                                <p className="before:content-['$'] before:mr-2 font-bold text-[#F44336]">{dash ? dash.expenseSum.toLocaleString() : 0}</p>
                            </>
                        )}
                    </div>
                </div>
                {/* <Overview dash={chart}/> */}
                <ChartsOverview chart={chart}/>
            </CardContent>
        </Card>
    )
}

export default ChartWrapper