'use client'

import {useTranslations} from 'next-intl';

import { SlQuestion } from "react-icons/sl";
import { RiSofaLine , RiCalendarScheduleLine } from "react-icons/ri";
import { PiMoneyWavyThin } from "react-icons/pi";

import {
    Card,
    CardContent,
    CardHeader,
    CardTitle,
} from "@/components/ui/card"
import { Skeleton } from "@/components/ui/skeleton";

import NetRevenue from "@/components/popover/net-revenue";
import Occupancy from "@/components/popover/occupancy";
import DailyRate from "@/components/popover/daily-rate";
import TotalExpense from "@/components/popover/total-expense";

interface Props {
    dash: any;
    lastmonth: string
    loading: boolean;
}
export function DataRevenue({dash, lastmonth, loading} : Props) {
    const t = useTranslations('Index');

    return (
        <div id='step-7' className="grid gap-4 md:grid-cols-2 lg:grid-cols-4 mt-4">
            <Card className="drop-shadow-lg transition-transform duration-300 transform hover:-translate-y-2">
                <CardHeader className="flex flex-row items-center justify-between space-y-0 pb-2">
                    {loading ? (
                        <Skeleton className="h-5 min-w-[78px] rounded-full" />
                    ) : (
                        <CardTitle className="text-sm font-medium">
                            {t('revenue')}
                        </CardTitle>
                    )}
                    <NetRevenue />
                </CardHeader>
                <CardContent className="space-y-1">
                    {loading ? (
                        <>
                            <Skeleton className="h-8 max-w-[252px] rounded-full" />
                            <Skeleton className="h-4 max-w-[252px] rounded-full" />
                        </>
                    ) : (
                        <>
                            <div className="text-2xl font-bold">$ {dash ? dash.income.toLocaleString() : 0}</div>
                            <p className="text-xs text-muted-foreground">
                            {dash ? (
                                dash.income_percentage > 0 ? (
                                    `+${dash.income_percentage.toFixed(2)}% ${t('compare')} (${lastmonth})`
                                ) : dash.income_percentage < 0 ? (
                                    `${dash.income_percentage.toFixed(2)}% ${t('compare')} (${lastmonth})`
                                ) : (
                                    `${dash.income_percentage}% ${t('compare')} (${lastmonth})`
                                )
                            ): (
                                `0% ${t('compare')} (${lastmonth})`
                            )}
                            </p>
                        </>
                    )}
                </CardContent>
            </Card>
            <Card className="drop-shadow-lg transition-transform duration-300 transform hover:-translate-y-2">
                <CardHeader className="flex flex-row items-center justify-between space-y-0 pb-2">
                    {loading ? (
                        <Skeleton className="h-5 min-w-[66px] rounded-full" />
                    ) : (
                        <CardTitle className="text-sm font-medium">
                            {t('occupancy')}
                        </CardTitle>
                    )}
                    <Occupancy />
                </CardHeader>
                <CardContent className="space-y-1">
                    {loading ? (
                        <>
                            <Skeleton className="h-8 max-w-[252px] rounded-full" />
                            <Skeleton className="h-4 max-w-[252px] rounded-full" />
                        </>
                    ) : (
                        <>
                            <div className="text-2xl font-bold">{dash ? dash.occupancy : 0} %</div>
                            <p className="text-xs text-muted-foreground">
                                {dash ? (
                                    dash.occupancy_percentage > 0 ? (
                                        `+${dash.occupancy_percentage.toFixed(2)}% ${t('compare')} (${lastmonth})`
                                    ) : dash.occupancy_percentage < 0 ? (
                                        `${dash.occupancy_percentage.toFixed(2)}% ${t('compare')} (${lastmonth})`
                                    ) : (
                                        `${dash.occupancy_percentage}% ${t('compare')} (${lastmonth})`
                                    )
                                ) : (
                                    `0% ${t('compare')} (${lastmonth})`
                                )}
                            </p>
                        </>
                    )}
                </CardContent>
            </Card>
            <Card className="drop-shadow-lg transition-transform duration-300 transform hover:-translate-y-2">
                <CardHeader className="flex flex-row items-center justify-between space-y-0 pb-2">
                    {loading ? (
                        <Skeleton className="h-5 min-w-[93px] rounded-full" />
                    ) : (
                        <CardTitle className="text-sm font-medium">
                            {t('dailyRate')}
                        </CardTitle>
                    )}
                    <DailyRate />
                </CardHeader>
                <CardContent className="space-y-1">
                    {loading ? (
                        <>
                            <Skeleton className="h-8 max-w-[252px] rounded-full" />
                            <Skeleton className="h-4 max-w-[252px] rounded-full" />
                        </>
                    ) : (
                        <>
                            <div className="text-2xl font-bold">$ {dash ? dash.dailyrate.toLocaleString() : 0}</div>
                            <p className="text-xs text-muted-foreground">
                                {dash ? (
                                    dash.dailyrate_percentage > 0 ? (
                                        `+${dash.dailyrate_percentage.toFixed(2)}% ${t('compare')} (${lastmonth})`
                                    ) : dash.dailyrate_percentage < 0 ? (
                                        `${dash.dailyrate_percentage.toFixed(2)}% ${t('compare')} (${lastmonth})`
                                    ) : (
                                        `${dash.dailyrate_percentage}% ${t('compare')} (${lastmonth})`
                                    )
                                ) : (
                                    `0% ${t('compare')} (${lastmonth})`
                                )}
                            </p>
                        </>
                    )}
                </CardContent>
            </Card>
            <Card className="drop-shadow-lg transition-transform duration-300 transform hover:-translate-y-2">
                <CardHeader className="flex flex-row items-center justify-between space-y-0 pb-2">
                    {loading ? (
                        <Skeleton className="h-5 min-w-[93px] rounded-full" />
                    ) : (
                        <CardTitle className="text-sm font-medium">
                            {t('expense')}
                        </CardTitle>
                    )}
                    <TotalExpense />
                </CardHeader>
                <CardContent className="space-y-1">
                    {loading ? (
                        <>
                            <Skeleton className="h-8 max-w-[252px] rounded-full" />
                            <Skeleton className="h-4 max-w-[252px] rounded-full" />
                        </>
                    ) : (
                        <>
                            <div className="text-2xl font-bold">$ {dash ? dash.expenseSum.toLocaleString() : 0}</div>
                            <p className="text-xs text-muted-foreground">
                                {dash ? (
                                    dash.expense_percentage > 0 ? (
                                        `+${dash.expense_percentage.toFixed(2)}% ${t('compare')} (${lastmonth})`
                                    ) : dash.expense_percentage < 0 ? (
                                        `${dash.expense_percentage.toFixed(2)}% ${t('compare')} (${lastmonth})`
                                    ) : (
                                        `${dash.expense_percentage}% ${t('compare')} (${lastmonth})`
                                    )
                                ) : (
                                    `0% ${t('compare')} (${lastmonth})`
                                )}
                            </p>
                        </>
                    )}
                    
                </CardContent>
            </Card>
        </div>
    )
}