'use client'

import { compareAsc, isAfter, parseISO } from "date-fns";

import { ScrollArea } from "@/components/ui/scroll-area"
import IconPopover from "@/components/popover/icon-popover";
import { format } from "date-fns";
import {
    Card,
    CardContent,
    CardDescription,
    CardFooter,
    CardHeader,
    CardTitle,
} from "@/components/ui/card"
import { Skeleton } from "@/components/ui/skeleton";

interface Props {
    data: any;
    loading: boolean;
}
export function RecentBooking({data, loading} : Props) {

    return (
        <ScrollArea className="h-[450px] w-full ">
            {loading ? (
                <Card className="mb-4">
                    <CardContent className="p-4 space-y-3">
                        <div className="flex items-center space-x-2" >
                            <Skeleton className="h-10 w-10 rounded-full" />
                            <Skeleton className="h-4 min-w-[130px] rounded-full" />
                        </div>
                        <div className="flex">
                            <div className="flex-grow space-y-1">
                                <Skeleton className="h-4 w-full rounded-full" />
                                <Skeleton className="h-4 w-full rounded-full" />
                            </div>
                            <div className="ml-2 flex-shrink font-medium">
                                <Skeleton className="h-4 w-[50px] rounded-full" />
                            </div>
                        </div>
                    </CardContent>
                </Card>
            ) : (
                data.length > 0 ? data.map((book: any) => (
                    <Card key={book.id} className="mb-4">
                        <CardContent className="p-4 space-y-3">
                            <div className="flex items-center" >
                                <IconPopover icon={book.channel} name={book.channelName}/>
                                <div className="flex-grow ml-4 space-y-1">
                                    <p className="text-sm leading-none ">
                                        <span>{format(new Date(book.start), 'MMM dd')} </span>
                                        -
                                        <span> {format(new Date(book.end), 'MMM dd, yyyy')}</span>
                                    </p>
                                </div>
                            </div>
                            <div className="flex">
                                <div className="flex-grow">
                                    <p className="text-sm text-muted-foreground">{book.title}</p>
                                    <p className="text-sm text-muted-foreground">
                                        <span>{book.adult > 1 ? book.adult + ' Adults' : book.adult + ' Adult'}</span>
                                        <span>
                                            {book.child ? (
                                                book.child > 1 ? ' ,' + book.child + ' Children' : ' ,' +  book.child + ' Child'
                                            ) : (
                                                ''
                                            )}
                                        </span>
                                    </p>
                                </div>
                                <div className="ml-2 flex-shrink font-medium">
                                    <span className="text-sm">{book.price}</span>
                                </div>
                            </div>
                        </CardContent>
                    </Card>
                )) : (
                    <div className="flex items-center justify-center h-full">
                        <p>No upcoming booking</p>
                    </div>
                )
            )}
        </ScrollArea>
    )
}