'use client'

import { Card } from "@/components/ui/card"
import Image from "next/image"

interface Props{
    data: any
}
const CardVilla = ({data}: Props) => {
    return (
        <Card className="flex aspect-square items-center justify-center">
            <div className="p-3 space-y-3">
                <Image src={data.img} alt="viila-image" width={200} height={200} className="object-cover w-56"/>
                <p className="font-medium text-sm min-h-10 text-center">{data.villa_name}</p>
            </div>
        </Card>
    )
}

export default CardVilla