'use client'
import { zodResolver } from "@hookform/resolvers/zod"
import { useForm } from "react-hook-form"
import { z } from "zod"
import {useTranslations} from 'next-intl';

import {
    Dialog,
    DialogClose,
    DialogContent,
    DialogDescription,
    DialogHeader,
    DialogTitle,
    DialogTrigger,
} from "@/components/ui/dialog"
import { Button } from "@/components/ui/button"
import { IoMdClose } from "react-icons/io";

import {
    Form,
    FormControl,
    FormDescription,
    FormField,
    FormItem,
    FormLabel,
    FormMessage,
} from "@/components/ui/form"
import { Input } from "@/components/ui/input";
import { toast } from 'sonner';
import { useState, useTransition } from "react";
import { deleteWhatsapp } from "@/actions/profile/deleteWaNotif";

const formSchema = z.object({
    id: z.string().min(1),
})

interface Props {
    wa: any
    loading: (value: boolean) => void
    reload: (value: boolean) => void

}

const DeleteWhatsapp = ({wa, loading, reload} : Props) => {
    const t = useTranslations('Index');
    const [open, setOpen] = useState(false)
    const [isPending, startTransition] = useTransition()
    const form = useForm<z.infer<typeof formSchema>>({
        resolver: zodResolver(formSchema),
        defaultValues: {
            id: `${wa.id}`,
        },
    })

    const onSubmit = async(values: z.infer<typeof formSchema>) => {
        setOpen(false)
        loading(true)
        startTransition(async() => {
            try {
                const del = await deleteWhatsapp(values.id);
                if(del.success){
                    loading(false)
                    reload(true)
                }
            } catch (error) {
                loading(false)
                toast.error('Smething went wrong !! Cant delete the whatsapp !!')
            }
        })
    }
    return (
        <Dialog>
            <DialogTrigger asChild>
                <Button variant="ghost" className="w-full">
                    {t('delete')}
                </Button>
            </DialogTrigger>
            <DialogContent>
                <DialogHeader>
                <DialogTitle>{t('qm1')}</DialogTitle>
                <DialogDescription>
                    {t('qm4')} <strong>+{wa.phone}</strong> {t('qm3')}.
                </DialogDescription>
                </DialogHeader>
                <Form {...form}>
                    <form onSubmit={form.handleSubmit(onSubmit)} className="space-y-3">
                        <FormField
                            control={form.control}
                            name="id"
                            render={({ field }) => (
                                <FormItem>
                                    <FormControl>
                                        <Input 
                                            {...field}
                                            className="hidden"/>
                                    </FormControl>
                                </FormItem>
                            )}
                        />
                        <div className="flex justify-end items-center gap-6">
                            <DialogClose asChild>
                                <Button type="submit">
                                    {t('deleteWa')}
                                </Button>
                            </DialogClose>
                            <DialogClose asChild>
                                <Button type="button" variant="destructive">
                                    {t('cancel')}
                                </Button>
                            </DialogClose>
                        </div>
                    </form>
                </Form>
            </DialogContent>
        </Dialog>
    )
}

export default DeleteWhatsapp