'use client'

import {
    Carousel,
    CarouselContent,
    CarouselItem,
    CarouselNext,
    CarouselPrevious,
} from "@/components/ui/carousel"
import CardVilla from "./card-villa"

interface Props {
    data: any
}
const ListVilla = ({data}: Props) => {
    return (
        <Carousel className="w-[80%] mx-auto" opts={{loop: true}}>
            <CarouselPrevious />
            <CarouselNext />
            <CarouselContent className="-ml-1">
                {data.map((item: any) => (
                    <CarouselItem key={item.room_id} className="pl-1 md:basis-1/2 lg:basis-1/3">
                        <div className="p-1">
                            <CardVilla data={item}/>
                        </div>
                    </CarouselItem>
                ))}
            </CarouselContent>
        </Carousel>
    )
}

export default ListVilla