'use client'

import { useEffect, useState } from "react";
import JoyRide, {EVENTS, STATUS} from "react-joyride";
import type { CallBackProps, Step } from "react-joyride";

interface State {
    run: boolean;
    stepIndex: number;
    steps: Step[];
}

interface Props {
    start: any;
    setStartTour: (value: boolean) => void;
    onTourEnd: () => void
}

const LiveTour = ({start, setStartTour, onTourEnd}: Props) => {
    const [progress, setProgress] = useState<number>(1)
    const totalSteps: number = 7;

    const generateSteps = (val: number): Step[] => [
        {
            target: '#live-1',
            content: (
                <div>
                    <p>This section provides a real time data per month based on your bookings data.</p>
                    <div className="absolute bottom-5 right-1/2 text-sm">
                        {val}/{totalSteps}
                    </div>
                </div>
            ),
            locale: {skip: <strong aria-label="skip">Skip</strong>},
            disableBeacon: true,
        },
        {
            target: '#live-2',
            content: (
                <div>
                    <p>This button will change the calendar to previous month.</p>
                    <div className="absolute bottom-5 right-1/2 text-sm">
                        {val}/{totalSteps}
                    </div>
                </div>
            ),
            locale: {skip: <strong aria-label="skip">Skip</strong>},
        },
        {
            target: '#live-3',
            content: (
                <div>
                    <p>This is current month.</p>
                    <div className="absolute bottom-5 right-1/2 text-sm">
                        {val}/{totalSteps}
                    </div>
                </div>
            ),
            locale: {skip: <strong aria-label="skip">Skip</strong>},
        },
        {
            target: '#live-4',
            content: (
                <div>
                    <p>This is selected total month shown at the calendar</p>
                    <div className="absolute bottom-5 right-1/2 text-sm">
                        {val}/{totalSteps}
                    </div>
                </div>
            ),
            locale: {skip: <strong aria-label="skip">Skip</strong>},
        },
        {
            target: '#live-5',
            content: (
                <div>
                    <p>This button will change the calendar to next month.</p>
                    <div className="absolute bottom-5 right-1/2 text-sm">
                        {val}/{totalSteps}
                    </div>
                </div>
            ),
            locale: {skip: <strong aria-label="skip">Skip</strong>},
        },
        {
            target: '#live-6',
            content: (
                <div>
                    <p>This is the villa name</p>
                    <div className="absolute bottom-5 right-1/2 text-sm">
                        {val}/{totalSteps}
                    </div>
                </div>
            ),
            locale: {skip: <strong aria-label="skip">Skip</strong>},
        },
        {
            target: '#live-7',
            content: (
                <div>
                    <p>This button will show the details of the selected villa. it will show the revenue, occupancy, booking source, and booking details for each month.</p>
                    <div className="absolute bottom-5 right-1/2 text-sm">
                        {val}/{totalSteps}
                    </div>
                </div>
            ),
            locale: {skip: <strong aria-label="skip">Skip</strong>, last: <span aria-label="last">Got it</span>},
        },
    ]

    const [{run, steps}, setState] = useState<State>({
        run: start, 
        stepIndex: 0, 
        steps: generateSteps(progress),
    });

    useEffect(() => {
        setState((prevState) => ({
            ...prevState,
            steps: generateSteps(progress),
        }))
    }, [progress])

    useEffect(() => {
        if(start){
            setState((prevState) => ({
                ...prevState,
                run: true,
                stepIndex: 0,
            }))
        }
    }, [start])

    const handleJoyrideCallback = (data: CallBackProps) => {
        const { status, type, index } = data;

        const finishedStatuses: string[] = [STATUS.FINISHED, STATUS.SKIPPED];
        if (finishedStatuses.includes(status)) {
            setState({steps, run: false, stepIndex: 0})
            setStartTour(false)
            onTourEnd()
        }else if (type === EVENTS.STEP_BEFORE) {
            setProgress(index + 1)
        }
    }
    return (
        <JoyRide
            run={run}
            steps={steps}
            continuous={true}
            callback={handleJoyrideCallback}
            hideCloseButton={true}
            showSkipButton={true}
            showProgress={false}
            disableCloseOnEsc
            disableOverlayClose
            spotlightPadding={5}
            styles={{
                options: {
                    zIndex: 10000,
                    overlayColor: "rgba(0,0,0,0.9)",
                },
                tooltipContainer: {
                    textAlign: "left",
                },
                buttonNext: {
                    backgroundColor: "#4285f4"
                },
                tooltipContent: {
                    padding: "0px",
                },
                buttonBack: {
                    marginRight: 10
                },
                overlay: {
                    border: "1px solid #4285f4",
                    overflowX: "hidden",
                },
                spotlight: {
                    border: "1px solid #4285f4"
                },
            }}
        />
    )
}

export default LiveTour