'use client'

import BookingTour from "./booking-tour";
import LiveTour from "./live-tour";
import OverviewTour from "./overview-tour";
import ProfileTour from "./profile-tour";
import ReportTour from "./reports-tour";


interface Props {
    start: any;
    setStartTour: (value: boolean) => void;
    onTourEnd: () => void
    active: string;
}
const Tutorial = ({start, setStartTour, onTourEnd, active}: Props) => {

    switch (active) {
        case 'cokcpit':
            return <LiveTour start={start} setStartTour={setStartTour} onTourEnd={onTourEnd} />;
        case 'bookings':
            return <BookingTour start={start} setStartTour={setStartTour} onTourEnd={onTourEnd} />;
        case 'report':
            return <ReportTour start={start} setStartTour={setStartTour} onTourEnd={onTourEnd} />;
        case 'profile':
            return <ProfileTour start={start} setStartTour={setStartTour} onTourEnd={onTourEnd} />;
        default:
            return <OverviewTour start={start} setStartTour={setStartTour} onTourEnd={onTourEnd} />;
    }
}

export default Tutorial