'use client'

import { Button } from "@/components/ui/button";
import { useEffect, useState } from "react";
import JoyRide, {EVENTS, STATUS} from "react-joyride";
import type { CallBackProps, Step } from "react-joyride";

interface State {
    run: boolean;
    stepIndex: number;
    steps: Step[];
}

interface Props {
    start: any;
    setStartTour: (value: boolean) => void;
    onTourEnd: () => void
}

const OverviewTour = ({start, setStartTour, onTourEnd}: Props) => {
    console.log('overview')
    const [progress, setProgress] = useState<number>(1)
    const totalSteps: number = 10;

    const generateSteps = (val: number): Step[] => [
        {
            content: (
                <div>
                    <p>Welcome to the owner dashboard</p>
                    <p>Let's start the tour, shall we ?</p>
                    <div className="absolute bottom-5 right-1/2 text-sm">
                        {val}/{totalSteps}
                    </div>
                </div>
            ),
            locale: {skip: <strong aria-label="skip">Skip</strong>},
            target: 'body',
            placement: "center",
            disableBeacon: true,
        },
        {
            target: '#step-1',
            content: (
                <div>
                    <p>Here is where you select / change the villa, by default the first villa will be the default.</p>
                    <div className="absolute bottom-5 right-1/2 text-sm">
                        {val}/{totalSteps}
                    </div>
                </div>
            ),
            locale: {skip: <strong aria-label="skip">Skip</strong>},
        },
        {
            target: '#step-2',
            content: (
                <div>
                    <p>This is profile menu, you can change the language and also logout using this menu.</p>
                    <div className="absolute bottom-5 right-1/2 text-sm">
                        {val}/{totalSteps}
                    </div>
                </div>
            ),
            locale: {skip: <strong aria-label="skip">Skip</strong>},
        },
        {
            target: '#step-3',
            content: (
                <div>
                    <p>This is main menu, where you can access all of the features of the dashboard.</p>
                    <div className="absolute bottom-5 right-1/2 text-sm">
                        {val}/{totalSteps}
                    </div>
                </div>
            ),
            locale: {skip: <strong aria-label="skip">Skip</strong>},
        },
        {
            target: '#step-4',
            content: (
                <div>
                    <p>This part showing your last reports available</p>
                    <div className="absolute bottom-5 right-1/2 text-sm">
                        {val}/{totalSteps}
                    </div>
                </div>
            ),
            locale: {skip: <strong aria-label="skip">Skip</strong>},
        },
        {
            target: '#step-5',
            content: (
                <div>
                    <p>You can change your last report using this part , select the month or year then click change</p>
                    <div className="absolute bottom-5 right-1/2 text-sm">
                        {val}/{totalSteps}
                    </div>
                </div>
            ),
            locale: {skip: <strong aria-label="skip">Skip</strong>},
        },
        {
            target: '#step-6',
            content: (
                <div>
                    <p>This button will download your last report or selected report as a pdf</p>
                    <div className="absolute bottom-5 right-1/2 text-sm">
                        {val}/{totalSteps}
                    </div>
                </div>
            ),
            locale: {skip: <strong aria-label="skip">Skip</strong>},
        },
        {
            target: '#step-7',
            content: (
                <div>
                    <p>This section your data from reports each section has their own tooltip (?) to explain what it is</p>
                    <div className="absolute bottom-5 right-1/2 text-sm">
                        {val}/{totalSteps}
                    </div>
                </div>
            ),
            locale: {skip: <strong aria-label="skip">Skip</strong>},
        },
        {
            target: '#step-8',
            content: (
                <div>
                    <p>This section provides a comprehensive view of the financial performance for a year, presenting key metrics and an annual summary chart.</p>
                    <div className="absolute bottom-5 right-1/2 text-sm">
                        {val}/{totalSteps}
                    </div>
                </div>
            ),
            locale: {skip: <strong aria-label="skip">Skip</strong>},
        },
        {
            target: '#step-9',
            content: (
                <div>
                    <p>This list of the confirmed reservations with a check-in in the future This will only show 10 entries maximum but you can click on “view all” to display all of them</p>
                    <div className="absolute bottom-5 right-1/2 text-sm">
                        {val}/{totalSteps}
                    </div>
                </div>
            ),
            locale: {skip: <strong aria-label="skip">Skip</strong>, last: <span aria-label="last">Got it</span>},
        },
    ]

    const [{run, steps}, setState] = useState<State>({
        run: start, 
        stepIndex: 0, 
        steps: generateSteps(progress),
    });

    useEffect(() => {
        setState((prevState) => ({
            ...prevState,
            steps: generateSteps(progress),
        }))
    }, [progress])

    useEffect(() => {
        if(start){
            setState((prevState) => ({
                ...prevState,
                run: true,
                stepIndex: 0,
            }))
        }
    }, [start])

    const handleJoyrideCallback = (data: CallBackProps) => {
        const { status, type, index } = data;

        const finishedStatuses: string[] = [STATUS.FINISHED, STATUS.SKIPPED];
        if (finishedStatuses.includes(status)) {
            setState({steps, run: false, stepIndex: 0})
            setStartTour(false)
            onTourEnd()
        }else if (type === EVENTS.STEP_BEFORE) {
            setProgress(index + 1)
        }
    }
    return (
        <JoyRide
            run={run}
            steps={steps}
            continuous={true}
            callback={handleJoyrideCallback}
            hideCloseButton={true}
            showSkipButton={true}
            showProgress={false}
            disableCloseOnEsc
            disableOverlayClose
            spotlightPadding={5}
            styles={{
                options: {
                    zIndex: 10000,
                    overlayColor: "rgba(0,0,0,0.9)",
                },
                tooltipContainer: {
                    textAlign: "left"
                },
                buttonNext: {
                    backgroundColor: "#4285f4"
                },
                buttonBack: {
                    marginRight: 10
                },
                overlay: {
                    border: "1px solid #4285f4"
                },
                spotlight: {
                    border: "1px solid #4285f4"
                },

            }}
        />
    )
}

export default OverviewTour