'use client'

import { useEffect, useState } from "react";
import JoyRide, {EVENTS, STATUS} from "react-joyride";
import type { CallBackProps, Step } from "react-joyride";

interface State {
    run: boolean;
    stepIndex: number;
    steps: Step[];
}

interface Props {
    start: any;
    setStartTour: (value: boolean) => void;
    onTourEnd: () => void
}

const ProfileTour = ({start, setStartTour, onTourEnd}: Props) => {
    const [progress, setProgress] = useState<number>(1)
    const totalSteps: number = 7;

    const generateSteps = (val: number): Step[] => [
        {
            target: '#profile-1',
            content: (
                <div>
                    <p>The profile section provides users with comprehensive control over their personal information and notification preferences.</p>
                    <div className="absolute bottom-5 right-1/2 text-sm">
                        {val}/{totalSteps}
                    </div>
                </div>
            ),
            locale: {skip: <strong aria-label="skip">Skip</strong>},
            disableBeacon: true,
        },
        {
            target: '#profile-2',
            content: (
                <div>
                    <p>The user data is displayed here</p>
                    <div className="absolute bottom-5 right-1/2 text-sm">
                        {val}/{totalSteps}
                    </div>
                </div>
            ),
            locale: {skip: <strong aria-label="skip">Skip</strong>},
        },
        {
            target: '#profile-3',
            content: (
                <div>
                    <p>To change your data click on the edit button</p>
                    <div className="absolute bottom-5 right-1/2 text-sm">
                        {val}/{totalSteps}
                    </div>
                </div>
            ),
            locale: {skip: <strong aria-label="skip">Skip</strong>},
        },
        {
            target: '#profile-4',
            content: (
                <div>
                    <p>List all of villas that connected to your account</p>
                    <div className="absolute bottom-5 right-1/2 text-sm">
                        {val}/{totalSteps}
                    </div>
                </div>
            ),
            locale: {skip: <strong aria-label="skip">Skip</strong>},
        },
        {
            target: '#profile-5',
            content: (
                <div>
                    <p>List all email notifications that registered to your account , you can edit or delete them by clicking on the action button</p>
                    <div className="absolute bottom-5 right-1/2 text-sm">
                        {val}/{totalSteps}
                    </div>
                </div>
            ),
            locale: {skip: <strong aria-label="skip">Skip</strong>},
        },
        {
            target: '#profile-6',
            content: (
                <div>
                    <p>To add a new email notification click on the add button</p>
                    <div className="absolute bottom-5 right-1/2 text-sm">
                        {val}/{totalSteps}
                    </div>
                </div>
            ),
            locale: {skip: <strong aria-label="skip">Skip</strong>},
        },
        {
            target: '#profile-7',
            content: (
                <div>
                    <p>Similar to the email notifications, this is list all whatsapp notifications that registered to your account , you can edit or delete them by clicking on the action button</p>
                    <div className="absolute bottom-5 right-1/2 text-sm">
                        {val}/{totalSteps}
                    </div>
                </div>
            ),
            locale: {skip: <strong aria-label="skip">Skip</strong>},
        },
        {
            target: '#profile-8',
            content: (
                <div>
                    <p>To add a new whatsapp notification click on the add button</p>
                    <div className="absolute bottom-5 right-1/2 text-sm">
                        {val}/{totalSteps}
                    </div>
                </div>
            ),
            locale: {skip: <strong aria-label="skip">Skip</strong>, last: <span aria-label="last">Got it</span>},
        },
    ]

    const [{run, steps}, setState] = useState<State>({
        run: start, 
        stepIndex: 0, 
        steps: generateSteps(progress),
    });

    useEffect(() => {
        setState((prevState) => ({
            ...prevState,
            steps: generateSteps(progress),
        }))
    }, [progress])

    useEffect(() => {
        if(start){
            setState((prevState) => ({
                ...prevState,
                run: true,
                stepIndex: 0,
            }))
        }
    }, [start])

    const handleJoyrideCallback = (data: CallBackProps) => {
        const { status, type, index } = data;

        const finishedStatuses: string[] = [STATUS.FINISHED, STATUS.SKIPPED];
        if (finishedStatuses.includes(status)) {
            setState({steps, run: false, stepIndex: 0})
            setStartTour(false)
            onTourEnd()
        }else if (type === EVENTS.STEP_BEFORE) {
            setProgress(index + 1)
        }
    }
    return (
        <JoyRide
            run={run}
            steps={steps}
            continuous={true}
            callback={handleJoyrideCallback}
            hideCloseButton={true}
            showSkipButton={true}
            showProgress={false}
            disableCloseOnEsc
            disableOverlayClose
            spotlightPadding={5}
            styles={{
                options: {
                    zIndex: 10000,
                    overlayColor: "rgba(0,0,0,0.9)",
                },
                tooltipContainer: {
                    textAlign: "left"
                },
                buttonNext: {
                    backgroundColor: "#4285f4"
                },
                buttonBack: {
                    marginRight: 10
                },
                overlay: {
                    border: "1px solid #4285f4"
                },
                spotlight: {
                    border: "1px solid #4285f4"
                },

            }}
        />
    )
}

export default ProfileTour