'use client';

import { Toaster } from "@/components/ui/sonner"
import React, { useState, useEffect } from 'react';

interface ClientOnlyProps {
    children: React.ReactNode;
}

const ClientOnly: React.FC<ClientOnlyProps> = ({ 
    children
}) => {
    const [hasMounted, setHasMounted] = useState(false);

    useEffect(() => {
        setHasMounted(true);
    }, [])

    if (!hasMounted) return null;

    return (
        <>
            {/* <GlobalContextProvider> */}
                {/* <GoogleAnalytics trackPageViews /> */}
                {children}
                <Toaster richColors position="top-center" />
            {/* </GlobalContextProvider> */}
        </>
    );
};

export default ClientOnly;