'use client'

import Link from "next/link"
import { RxQuestionMark, RxQuestionMarkCircled } from "react-icons/rx";
import { IoIosSend } from "react-icons/io";
import { IoPlay } from "react-icons/io5";

import Feedback from "../dashboard/tutorial/feedback";
import { Button } from "../ui/button";
import { useState } from "react";
import { Popover, PopoverContent, PopoverTrigger } from "../ui/popover";
import Help from "../dashboard/tutorial/help";
import LearnMore from "../dashboard/tutorial/learn-more";

interface Props {
    startTour: () => void;
}
const Footer = ({startTour}: Props) => {
    const [open, setOpen] = useState(false)
    const [value, setValue] = useState("")
    const [menuOpen, setMenuOpen] = useState(false)

    return (
        <footer>
            <div className="lg:container w-full mx-auto">
                <div className="flex h-14 items-center justify-center px-4 gap-4 border-t">
                    <p className="text-sm text-center">© Copyright {new Date().getFullYear()} - Owner Dashboard by <Link href='https://balimanagement.villas' className="underline underline-offset-2">Bali Management Villas</Link>  </p>
                </div>
            </div>
            <div className="fixed bottom-20 right-5 z-40">

                {/* <div className="aspect-video bg-[#4285f4] p-3 rounded-full drop-shadow-lg cursor-pointer">
                    <RxQuestionMark className="h-8 w-8 text-white"/>
                </div> */}
                <Popover open={open} onOpenChange={setOpen}>
                    <PopoverTrigger asChild>
                        <Button
                            variant="outline"
                            role="combobox"
                            aria-expanded={open}
                            className="h-16 w-16 bg-[#4285f4] p-3 rounded-full drop-shadow-lg cursor-pointer hover:bg-[#4285f4]"
                            >
                            <RxQuestionMark className="h-8 w-8 text-white"/>
                        </Button>
                    </PopoverTrigger>
                    <PopoverContent className="w-52 px-0">
                        <div className="grid gap-1">
                            {/* <LearnMore /> */}
                            <div 
                                className="lg:flex hidden items-center gap-2 cursor-pointer py-2 px-3 hover:bg-stone-200"
                                onClick={() => {setOpen(false), startTour()}}
                            >
                                <IoPlay className="h-5 w-5"/>
                                <span className="text-sm">Start Tour this page</span>
                            </div>
                            
                            <Help />
                            <Feedback />
                        </div>
                    </PopoverContent>
                </Popover>
            </div>
        </footer>
    )
}

export default Footer