'use server'

import { auth } from "@/auth";
import axios from "axios";

export const changeDash = async (roomId: any, month: number, year: number) => {
    try {
        const session = await auth()

        if(session){
            const dashData  = await axios.post(
                'https://dash.bahasahospitality.com/api/v2/changeDashboardV2',
                {
                    roomId: roomId,
                    month: month,
                    year: year,
                },
                {
                    headers: {
                        'Authorization': `Bearer ${session.accessToken}`,
                        'Accept': 'application/json'
                    }
                }
            );
            if (!dashData) throw Error;
            return dashData.data;
        }else{
            return { success: false }
        }
    } catch (error) {
        console.log(error)
    }
}