'use server'

import { auth } from "@/auth";
import axios from "axios";

export const getCurrentUser = async () => {
    try {
        const session = await auth()
        if(session){
            const currentAccount  = await axios.get(
                'https://dash.bahasahospitality.com/api/user',
                {
                    headers: {
                        'Authorization': `Bearer ${session.accessToken}`,
                        'Accept': 'application/json'
                    }
                }
            );
            
            if (!currentAccount) throw Error;
            return currentAccount.data;
        }else{
            return { success: false, message: 'Unauthenticated' }   
        }
    } catch (error) {
        console.log(error)
    }
}