'use server'

import { auth } from "@/auth";
import axios from "axios";

export const updateUser = async (data: any) => {
    try {
        const session = await auth()
        if(session){
            const currentAccount  = await axios.post(
                'https://dash.bahasahospitality.com/api/user/update',
                data,
                {
                    headers: {
                        'Authorization': `Bearer ${session.accessToken}`,
                        'Accept': 'application/json'
                    }
                }
            );
            if (!currentAccount) throw Error;
            return currentAccount.data;
        }else{
            return { success: false, message: 'Unauthenticated' }   
        }
    } catch (error) {
        console.log(error)
    }
}