
'use server'

import { auth } from "@/auth";
import axios from "axios";

export const editWhatsapp = async (id: any, villaId: any, whatsapp: any) => {
    try {
        const session = await auth()
        if(session){
            const currentAccount  = await axios.post(
                'https://dash.bahasahospitality.com/api/v2/notif/whatsapp/edit',
                {
                    id: id,
                    villa_id: villaId,
                    whatsapp: whatsapp,
                },
                {
                    headers: {
                        'Authorization': `Bearer ${session.accessToken}`,
                        'Accept': 'application/json'
                    }
                }
            );
            if (!currentAccount) throw Error;
            return currentAccount.data;
        }else{
            return { success: false , message: 'Unauthenticated'} 
        }
    } catch (error) {
        console.log(error)
    }
}