"use client"

import { Button } from "@/components/ui/button";
import { ColumnDef } from "@tanstack/react-table"
import { format, isBefore, isToday, isWithinInterval, parseISO } from "date-fns";
import Image from "next/image";
import { RiArrowUpDownFill } from "react-icons/ri";


export const columns: ColumnDef<any>[] = [
    {
        accessorKey: "status",
        header: () => <p id="booking-2" className="font-bold text-black dark:text-white">Status</p>,
        cell: ({ row }) => {
            let status = "";
            const currentDate = new Date();
            const arrivalDate = parseISO(row.original.start);
            const departureDate = parseISO(row.original.end);

            if (isToday(departureDate)) {
                status = "Checking out today";
            } else if (isWithinInterval(currentDate, { start: arrivalDate, end: departureDate })) {
                status = "Currently hosting";
            } else if (isBefore(currentDate, arrivalDate)) {
                status = "Upcoming Booking";
            } else {
                status = "Complete";
            }
            return <p className="min-w-32 font-medium">{status}</p>
        }
    },
    {
        accessorKey: "guest",
        header: () => <p id="booking-3" className="font-bold text-black dark:text-white">Guest</p>,
        cell: ({ row }) => {
            const guest = row.original;
            return (
                <div className="min-w-28 max-h-52">
                    <p className='font-semibold underline underline-offset-2 capitalize'>{guest.title}</p>
                    <p className='text-sm'>
                        <span>{guest.adult > 1 ? guest.adult + ' Adults' : guest.adult + ' Adult'}</span>
                        <span>
                            {guest.child ? (
                                guest.child > 1 ? ' ,' + guest.child + ' Children' : ' ,' +  guest.child + ' Child'
                            ) : (
                                ''
                            )}
                        </span>
                    </p>
                </div>
            )
        },
    },
    {
        accessorKey: "checkin",
        header: () => <p id="booking-4" className="font-bold text-black dark:text-white">Check-in</p>,
        cell: ({ row }) => {
            const start = row.original.start;
            return <p>{format(new Date(start), 'MMM dd, yyyy')}</p>
        }
    },
    {
        accessorKey: "checkout",
        header: () => <p id="booking-5" className="font-bold text-black dark:text-white">Check-out</p>,
        cell: ({ row }) => {
            const end = row.original.end;
            return <p>{format(new Date(end), 'MMM dd, yyyy')}</p>
        }
    },
    {
        accessorKey: "channel",
        header: () => <p id="booking-6" className="font-bold text-black dark:text-white">Channel</p>,
        cell: ({ row }) => {
            const icon = row.original.channel;
            return (
                <Image src={icon} alt="image" width={56} height={56}/>
            )
        },
    },
    {
        accessorKey: "code",
        header: () => <p id="booking-7" className="min-w-28 font-bold text-black dark:text-white">Booking code</p>,
        cell: ({ row }) => {
            const code = row.original.id;
            return <p>{code}</p>
        }
    },
    {
        accessorKey: "paid",
        header: () => <p id="booking-8" className="min-w-28 font-bold text-black dark:text-white">Total payout</p>,
        cell: ({ row }) => {
            const price = row.original.price;
            return <p>{price}</p>
        }
    },
]
