"use client"

import { Area, AreaChart, CartesianGrid, XAxis, YAxis } from "recharts"

import {
    ChartConfig,
    ChartContainer,
    ChartTooltip,
    ChartTooltipContent,
    ChartLegend, 
    ChartLegendContent,
} from "@/components/ui/chart"


const chartConfig = {
    revenue: {
        label: "Revenue",
        color: "hsl(var(--chart-1))",
    },
    profit: {
        label: "Profit",
        color: "hsl(var(--chart-2))",
    },
    expenses: {
        label: "Expenses",
        color: "hsl(var(--chart-3))",
    },
} satisfies ChartConfig

interface Props {
    chart: any
}
const ChartsOverview = ({chart}: Props) => {

    const CustomTooltip = ({ active, payload, label, indicatorColor }: any) => {
        if (active && payload && payload.length) {
            return (
                <div className="bg-white border space-y-2 p-3 min-w-[8rem]">
                    <p className="font-semibold capitalize">{label}</p>
                    <div className="flex w-full items-stretch gap-2">
                        <div className="shrink-0 rounded-[2px] h-2.5 w-2.5 border-[#4CAF50] bg-[#4CAF50]"/>
                        <div className="flex flex-1 justify-between leading-none items-center gap-2">
                            <div className="grid gap-1.5">
                                <span className="text-muted-foreground">
                                    Revenue
                                </span>
                            </div>
                            <span className="font-mono font-medium tabular-nums text-foreground">
                                ${payload[0].value.toLocaleString()}
                            </span>
                        </div>
                    </div>
                    <div className="flex w-full items-stretch gap-2">
                        <div className="shrink-0 rounded-[2px] h-2.5 w-2.5 border-[#2196F3] bg-[#2196F3]"/>
                        <div className="flex flex-1 justify-between leading-none items-center gap-2">
                            <div className="grid gap-1.5">
                                <span className="text-muted-foreground">
                                    Profit
                                </span>
                            </div>
                            <span className="font-mono font-medium tabular-nums text-foreground">
                                ${payload[1].value.toLocaleString()}
                            </span>
                        </div>
                    </div>
                    <div className="flex w-full items-stretch gap-2">
                        <div className="shrink-0 rounded-[2px] h-2.5 w-2.5 border-[#F44336] bg-[#F44336]"/>
                        <div className="flex flex-1 justify-between leading-none items-center gap-2">
                            <div className="grid gap-1.5">
                                <span className="text-muted-foreground">
                                Expenses
                                </span>
                            </div>
                            <span className="font-mono font-medium tabular-nums text-foreground">
                                ${payload[2].value.toLocaleString()}
                            </span>
                        </div>
                    </div>
                </div>
            );
        }
    
        return null;
    };

    return (
        <ChartContainer config={chartConfig} className="lg:min-h-[300px] h-full w-full">
            <AreaChart
                accessibilityLayer
                data={chart}
                margin={{
                    left: 10,
                    right: 10,
                }}
            >
                <defs>
                    <linearGradient id="colorRevenue" x1="0" y1="0" x2="0" y2="1">
                        <stop offset="5%" stopColor="var(--color-revenue)" stopOpacity={0.8}/>
                        <stop offset="95%" stopColor="var(--color-revenue)" stopOpacity={0.1}/>
                    </linearGradient>
                    <linearGradient id="colorProfit" x1="0" y1="0" x2="0" y2="1">
                        <stop offset="5%" stopColor="var(--color-profit)" stopOpacity={0.8}/>
                        <stop offset="95%" stopColor="var(--color-profit)" stopOpacity={0.1}/>
                    </linearGradient>
                    <linearGradient id="colorExpenses" x1="0" y1="0" x2="0" y2="1">
                        <stop offset="5%" stopColor="var(--color-expenses)" stopOpacity={0.8}/>
                        <stop offset="95%" stopColor="var(--color-expenses)" stopOpacity={0.1}/>
                    </linearGradient>
                </defs>
                <CartesianGrid vertical={false} />
                <ChartLegend content={<ChartLegendContent />} />
                <YAxis
                    stroke="#888888"
                    fontSize={12}
                    tickLine={false}
                    axisLine={false}
                    tickFormatter={(value) => `$${value}`}
                />
                <XAxis
                    dataKey="name"
                    tickLine={false}
                    axisLine={false}
                    tickMargin={8}
                    tickFormatter={(value) => value.slice(0, 3)}
                />
                <ChartTooltip
                    cursor={false}
                    content={<CustomTooltip />}
                />
                <Area
                    dataKey="revenue"
                    type="natural"
                    fill="url(#colorRevenue)"
                    fillOpacity={1}
                    stroke="var(--color-revenue)"
                    stackId="a"
                />
                <Area
                    dataKey="profit"
                    type="natural"
                    fill="url(#colorProfit)"
                    fillOpacity={1}
                    stroke="var(--color-profit)"
                    stackId="a"
                />
                <Area
                    dataKey="expenses"
                    type="natural"
                    fill="url(#colorExpenses)"
                    fillOpacity={1}
                    stroke="var(--color-expenses)"
                    stackId="a"
                />
            </AreaChart>
        </ChartContainer>
    )
}

export default ChartsOverview