"use client";

import React, {useCallback, useEffect, useMemo } from "react";
import { SlArrowLeft, SlArrowRight } from "react-icons/sl";
import { Button } from "../../ui/button";

interface Props {
    value: number;
    onChange: (value: number) => void;
}

const MonthCounter = ({ value, onChange }: Props) => {

    const monthNames = useMemo(() => [
        { no: 1, name: 'January' },
        { no: 2, name: 'February' },
        { no: 3, name: 'March' },
        { no: 4, name: 'April' },
        { no: 5, name: 'May' },
        { no: 6, name: 'June' },
        { no: 7, name: 'July' },
        { no: 8, name: 'August' },
        { no: 9, name: 'September' },
        { no: 10, name: 'October' },
        { no: 11, name: 'November' },
        { no: 12, name: 'December' },
    ], []);

    const onAdd = () => {
        onChange(value === 12 ? 1 : value + 1);
    };

    const onReduce = () => {
        onChange(value === 1 ? 12 : value - 1);
    };

    return (
        <div className="flex flex-row items-center justify-between">
            <div className="flex flex-row items-center justify-between w-full">
                <Button
                onClick={onReduce}
                className="
                    w-10
                    h-10
                    border-neutral-400
                    flex
                    items-center
                    justify-center
                    dark:text-primary-foreground
                    cursor-pointer
                    hover: opacity-80
                    transition
                    dark:border-primary-foreground
                "
                >
                <SlArrowLeft />
                </Button>
                <div className="font-light">{monthNames.find(month => month.no === Number(value))?.name}</div>
                <Button
                onClick={onAdd}
                    className="
                        w-10
                        h-10
                        border-neutral-400
                        flex
                        items-center
                        justify-center
                        dark:text-primary-foreground
                        cursor-pointer
                        hover: opacity-80
                        transition
                        dark:border-primary-foreground
                    "
                    >
                <SlArrowRight />
                </Button>
            </div>
        </div>
    )
}

export default MonthCounter