"use client"

import { useMemo, memo } from "react";
import { Area, AreaChart, Legend, ResponsiveContainer, Tooltip, XAxis, YAxis } from "recharts"
import { format, addMonths, startOfMonth } from 'date-fns';
 // Current date

interface Props {
    dash: any;
}
const Overview = ({dash} : Props) => {
    const date = new Date();

    const currentDate = new Date();

    const emptyData = useMemo(() => {
        const data = [];
        const currentYear = currentDate.getFullYear();
        const currentMonth = currentDate.getMonth(); // 0 (January) to 11 (December)

        for (let month = 0; month <= currentMonth; month++) {
            const date = new Date(currentYear, month, 1);
            data.push({
                name: format(date, "MMMM"), // Full month name
                revenue: 0,
                profit: 0,
                expenses: 0,
            });
        }
        return data;
    }, [currentDate]);

    const CustomTooltip = ({ active, payload, label }: any) => {
        if (active && payload && payload.length) {
            return (
                <div className="bg-white border p-3">
                    <p className="font-semibold capitalize">{label}</p>
                    <p className="capitalize text-sm">Revenue : <span> $ {payload[0].value.toLocaleString()}</span></p>
                    <p className="capitalize text-sm">Profit : <span> $ {payload[1].value.toLocaleString()}</span></p>
                    <p className="capitalize text-sm">Expenses : <span> $ {payload[2].value.toLocaleString()}</span></p>
                </div>
            );
        }
    
        return null;
    };
    return (
        <ResponsiveContainer width="100%" height={350}>
            <AreaChart width={600} height={300} data={dash ? dash : emptyData}>
                <defs>
                    <linearGradient id="colorRevenue" x1="0" y1="0" x2="0" y2="1">
                        <stop offset="5%" stopColor="#4CAF50" stopOpacity={0.8}/>
                        <stop offset="95%" stopColor="#4CAF50" stopOpacity={0}/>
                    </linearGradient>
                    <linearGradient id="colorProfit" x1="0" y1="0" x2="0" y2="1">
                        <stop offset="5%" stopColor="#2196F3" stopOpacity={0.8}/>
                        <stop offset="95%" stopColor="#2196F3" stopOpacity={0}/>
                    </linearGradient>
                    <linearGradient id="colorExpense" x1="0" y1="0" x2="0" y2="1">
                        <stop offset="5%" stopColor="#F44336" stopOpacity={0.8}/>
                        <stop offset="95%" stopColor="#F44336" stopOpacity={0}/>
                    </linearGradient>
                </defs>
                <XAxis
                    dataKey="name"
                    stroke="#888888"
                    fontSize={12}
                    tickLine={false}
                    axisLine={false}
                />
                <YAxis
                    stroke="#888888"
                    fontSize={12}
                    tickLine={false}
                    axisLine={false}
                    tickFormatter={(value) => `$${value}`}
                />
                <Legend />
                <Tooltip content={<CustomTooltip />} />
                <Area type="monotone" dataKey="revenue" stroke="#4CAF50" fillOpacity={1} fill="url(#colorRevenue)" />
                <Area type="monotone" dataKey="profit" stroke="#2196F3" fillOpacity={1} fill="url(#colorProfit)" />
                <Area type="monotone" dataKey="expenses" stroke="#F44336" fillOpacity={1} fill="url(#colorExpense)" />
            </AreaChart >
        </ResponsiveContainer>
    )
}

export default memo(Overview);