'use client'
import React, { useEffect, useState } from 'react'
import { LuCalendarDays } from "react-icons/lu";
import { format, getMonth, getYear } from "date-fns"

import { cn } from "@/lib/utils"
import { Button } from "@/components/ui/button"
import {
    Popover,
    PopoverContent,
    PopoverTrigger,
} from "@/components/ui/popover"
import YearCounter from '@/components/dashboard/overview/year-counter';
import MonthCounter from '@/components/dashboard/overview/month-counter';


const date = new Date(); // Current date
const monthIndex = getMonth(date); // Month index (0-11)
const monthNumber = monthIndex + 1; // Month number (1-12)
const yearNumber = getYear(date); // Year number

interface Props {
    className?: string;
    month: number;
    year: number;
    setYear: (value: number) => void;
    setMonth: (value: number) => void;
    onChange: (value: boolean, m: number, y: number) => void;
    loading: boolean;
}
const PeriodPicker = ({className, month, year, setYear, setMonth, onChange, loading}: Props) => {
    const [selectedMonth, setSelectedMonth] = useState<number>(month);
    const [selectedYear, setSelectedYear] = useState<number>(year);
    const [open, setOpen] = useState(false);

    
    useEffect(() => {
        setSelectedMonth(month);
        setSelectedYear(year);
    }, [month, year]);

    const handleChange = () => {
        if (selectedMonth === month && selectedYear === year) {
            onChange(false , month, year);
        }else{
            setMonth(selectedMonth);
            setYear(selectedYear);
            setOpen(false)
            onChange(true, selectedMonth, selectedYear);
        }
    };

    const handleMonth = (value: number) => {
        setSelectedMonth(value)
    }

    const handleYear = (value: number) => {
        setSelectedYear(value)
    }
    return (
        <div className={cn("grid gap-2", className)}>
            <Popover open={open} onOpenChange={setOpen}>
                <PopoverTrigger asChild disabled={loading}>
                    <Button
                        id="step-5"
                        variant={"outline"}
                        className={cn(
                        "lg:w-[260px] w-[180px] justify-start text-left font-normal",
                        !month && !year && "text-muted-foreground"
                        )}
                        // onClick={() => setOpen(true)}
                    >
                        <LuCalendarDays className="mr-2 h-4 w-4" />
                        {month ? format(new Date(selectedYear, selectedMonth - 1, 1), "MMMM yyyy") : <span>Pick a date</span>}
                    </Button>
                </PopoverTrigger>
                <PopoverContent className="lg:w-[260px] w-[240px] p-0" align="start" >
                    <div className="space-y-3 p-3">
                        <YearCounter value={selectedYear} onChange={handleYear} min={yearNumber}/>
                        <MonthCounter value={selectedMonth} onChange={handleMonth}/>
                        <Button className='w-full' onClick={handleChange} disabled={loading}>Change</Button>
                    </div>
                </PopoverContent>
            </Popover>
        </div>
    )
}

export default PeriodPicker