"use client";

import React, {useCallback, useEffect, useState} from "react";
import { SlArrowLeft, SlArrowRight } from "react-icons/sl";
import { Button } from "../../ui/button";

interface CounterProps {
    value: number;
    min: number;
    onChange: (value: number) => void;
}
const YearCounter= ({ min, value, onChange} : CounterProps) => {

    useEffect(() => {
        onChange(value)
    },[])

    const onAdd = useCallback(() => {
        onChange(value  + 1);
    }, [onChange, value ]);

    const onReduce = useCallback(() => {
        if (value  > min) {
            onChange(value  - 1);
        }
    }, [value , onChange]);

    return (
        <div className="flex flex-row items-center justify-between">
            <div className="flex flex-row items-center justify-between w-full">
                <Button
                onClick={onReduce}
                className="
                    w-10
                    h-10
                    border-neutral-400
                    flex
                    items-center
                    justify-center
                    dark:text-primary-foreground
                    cursor-pointer
                    hover: opacity-80
                    transition
                    dark:border-primary-foreground
                "
                >
                <SlArrowLeft />
                </Button>
                <div className="font-light ">{value}</div>
                <Button
                onClick={onAdd}
                    className="
                        w-10
                        h-10
                        border-neutral-400
                        flex
                        items-center
                        justify-center
                        dark:text-primary-foreground
                        cursor-pointer
                        hover: opacity-80
                        transition
                        dark:border-primary-foreground
                    "
                    >
                <SlArrowRight />
                </Button>
            </div>
        </div>
    );
};

export default YearCounter;
