'use client'

import ReportPopover from "@/components/popover/report-popover";
import {
    Card,
    CardContent,
    CardDescription,
    CardHeader,
    CardTitle,
} from "@/components/ui/card"
import { Skeleton } from "@/components/ui/skeleton";
import Link from "next/link";
import { useMemo } from "react";
import {useTranslations} from 'next-intl';
import { format } from "date-fns";
import { Separator } from "@/components/ui/separator";
import { Tabs, TabsContent, TabsList, TabsTrigger } from "@/components/ui/tabs";

interface Props {
    dash: any;
    selected: any;
    year: number;
    loading: boolean;
}

const handleDownload = (url: string, villaName: string, reportName: string, year: number) => {
    const link = document.createElement('a');
        link.href = url;
        link.download = `${villaName}-${reportName}-${year}.pdf`;
        document.body.appendChild(link);
        link.click();
        document.body.removeChild(link);
    };

const Report = ({dash, selected, year, loading} : Props) => {
    const t = useTranslations('Index');
    const iframeSrc = useMemo(() => {
        if(dash){
            return dash.data;
        }
    }, [dash]);

    const sortedData = dash.data.allreport.sort((a: any, b: any) => Number(b.month) - Number(a.month));

    const handleDownloadClick = () => {
        handleDownload(
            dash ? dash.data.report : '#',
            selected ? selected.villa_name : 'villa',
            dash ? dash.data.currentlasreport : 'report',
            year
        );
    };
    
    return (
        <Card className="drop-shadow-lg">
            <CardHeader>
                <div id="report-1" className="flex items-center w-fit">
                    {loading ? (
                        <Skeleton className="h-6 min-w-[162px] rounded-full" />
                    ) : (
                        <CardTitle>{t('report')}</CardTitle>
                    )}
                    <div className="ml-2">
                        <ReportPopover />
                    </div>
                </div>
                    {loading ? (
                        <Skeleton className="h-5 w-[132px] rounded-full" />
                    ) : (
                        <CardDescription>{t('pdf')}</CardDescription>
                    )}
            </CardHeader>
            <CardContent>
                <Tabs defaultValue={String(dash.data.currentReports)} className="w-full">
                    <div className="flex items-start gap-3">
                        <div className="shrink lg:px-6 w-[160px] md:w-auto">
                            <TabsList id="report-2" className="flex flex-col gap-3 h-full bg-transparent w-full">
                                <p>Available Reports</p>
                                <Separator />
                                {sortedData.length > 1 ? (
                                    sortedData.map((item: any) => (
                                        <TabsTrigger value={String(item.month)} className="border w-full drop-shadow-xl bg-primary text-white">{format(new Date(item.year , item.month - 1 , 1), 'MMMM yyyy')}</TabsTrigger>
                                    ))
                                ) : (
                                    <p>No Available Reports</p>
                                )}
                            </TabsList>
                        </div>
                        <div className="grow">
                            {sortedData.length > 1 ? (
                                sortedData.map((item: any) => (
                                    <TabsContent id="report-3" value={item.month}>
                                        <div className="lg:block hidden space-y-3">
                                            {loading ? (
                                                <Skeleton className="h-5 w-[235px] rounded-full" />
                                            ) : (
                                                <p>
                                                    <Link href={`https://dash.bahasahospitality.com${item.document}`} target="_blank" className="underline font-semibold">{t('click')}</Link>
                                                    <span className="ml-2">{t('pdfNotShow')}</span>
                                                </p>
                                            )}
                                            <iframe src={`https://dash.bahasahospitality.com${item.document}`} className="w-full lg:h-[650px] h-full"></iframe>
                                        </div>
                                        <div className="lg:hidden block space-y-3">
                                            {loading ? (
                                                <Skeleton className="h-5 w-[235px] rounded-full" />
                                            ) : (
                                                <div>
                                                    <button 
                                                        onClick={handleDownloadClick} 
                                                        className="underline font-semibold"
                                                    >
                                                        {t('download')}
                                                    </button>
                                                    <span className="ml-2">{t('yourReport')} {format(new Date(item.year , item.month - 1 , 1), 'MMMM yyyy')}</span>
                                                </div>
                                            )}
                                        </div>
                                    </TabsContent>
                                ))
                            ) : (
                                <h2>{t('noReport')}</h2>
                            )}
                        </div>
                    </div>
                </Tabs>
            </CardContent>
        </Card>
    )
}

export default Report