'use client'

import { useEffect, useState } from "react";
import JoyRide, {EVENTS, STATUS} from "react-joyride";
import type { CallBackProps, Step } from "react-joyride";

interface State {
    run: boolean;
    stepIndex: number;
    steps: Step[];
}

interface Props {
    start: any;
    setStartTour: (value: boolean) => void;
    onTourEnd: () => void
}

const BookingTour = ({start, setStartTour, onTourEnd}: Props) => {
    const [progress, setProgress] = useState<number>(1)
    const totalSteps: number = 10;

    const generateSteps = (val: number): Step[] => [
        {
            target: '#booking-1',
            content: (
                <div>
                    <p>This list of the confirmed reservations with a check-in in the future. You can check the details of a booking by simply clicking on it.</p>
                    <div className="absolute bottom-5 right-1/2 text-sm">
                        {val}/{totalSteps}
                    </div>
                </div>
            ),
            locale: {skip: <strong aria-label="skip">Skip</strong>},
            disableBeacon: true,
        },
        {
            target: '#booking-2',
            content: (
                <div>
                    <p>Status of the booking, it has 3 status: Checking out today, Upcoming Booking, Completed</p>
                    <div className="absolute bottom-5 right-1/2 text-sm">
                        {val}/{totalSteps}
                    </div>
                </div>
            ),
            locale: {skip: <strong aria-label="skip">Skip</strong>},
        },
        {
            target: '#booking-3',
            content: (
                <div>
                    <p>Guest information, it has the guest name, and total guest</p>
                    <div className="absolute bottom-5 right-1/2 text-sm">
                        {val}/{totalSteps}
                    </div>
                </div>
            ),
            locale: {skip: <strong aria-label="skip">Skip</strong>},
        },
        {
            target: '#booking-4',
            content: (
                <div>
                    <p>Check-in Date, the guest will check-in at this date</p>
                    <div className="absolute bottom-5 right-1/2 text-sm">
                        {val}/{totalSteps}
                    </div>
                </div>
            ),
            locale: {skip: <strong aria-label="skip">Skip</strong>},
        },
        {
            target: '#booking-5',
            content: (
                <div>
                    <p>Check-out Date, the guest will check-out at this date</p>
                    <div className="absolute bottom-5 right-1/2 text-sm">
                        {val}/{totalSteps}
                    </div>
                </div>
            ),
            locale: {skip: <strong aria-label="skip">Skip</strong>},
        },
        {
            target: '#booking-6',
            content: (
                <div>
                    <p>Channel, the channel of the booking or the platform where the booking is made</p>
                    <div className="absolute bottom-5 right-1/2 text-sm">
                        {val}/{totalSteps}
                    </div>
                </div>
            ),
            locale: {skip: <strong aria-label="skip">Skip</strong>},
        },
        {
            target: '#booking-7',
            content: (
                <div>
                    <p>Booking code, the unique code of the booking that can be used to check the booking details</p>
                    <div className="absolute bottom-5 right-1/2 text-sm">
                        {val}/{totalSteps}
                    </div>
                </div>
            ),
            locale: {skip: <strong aria-label="skip">Skip</strong>},
        },
        {
            target: '#booking-8',
            content: (
                <div>
                    <p>Total payout, the total paid by the guest</p>
                    <div className="absolute bottom-5 right-1/2 text-sm">
                        {val}/{totalSteps}
                    </div>
                </div>
            ),
            locale: {skip: <strong aria-label="skip">Skip</strong>},
        },
        {
            target: '#booking-9',
            content: (
                <div>
                    <p>List of the bookings, you can check the details of a booking by simply clicking on it.</p>
                    <div className="absolute bottom-5 right-1/2 text-sm">
                        {val}/{totalSteps}
                    </div>
                </div>
            ),
            locale: {skip: <strong aria-label="skip">Skip</strong>},
        },
        {
            target: '#booking-10',
            content: (
                <div>
                    <p>The pagination of the bookings</p>
                    <div className="absolute bottom-5 right-1/2 text-sm">
                        {val}/{totalSteps}
                    </div>
                </div>
            ),
            locale: {skip: <strong aria-label="skip">Skip</strong>, last: <span aria-label="last">Got it</span>},
        },
    ]

    const [{run, steps}, setState] = useState<State>({
        run: start, 
        stepIndex: 0, 
        steps: generateSteps(progress),
    });

    useEffect(() => {
        setState((prevState) => ({
            ...prevState,
            steps: generateSteps(progress),
        }))
    }, [progress])

    useEffect(() => {
        if(start){
            setState((prevState) => ({
                ...prevState,
                run: true,
                stepIndex: 0,
            }))
        }
    }, [start])

    const handleJoyrideCallback = (data: CallBackProps) => {
        const { status, type, index } = data;

        const finishedStatuses: string[] = [STATUS.FINISHED, STATUS.SKIPPED];
        if (finishedStatuses.includes(status)) {
            setState({steps, run: false, stepIndex: 0})
            setStartTour(false)
            onTourEnd()
        }else if (type === EVENTS.STEP_BEFORE) {
            setProgress(index + 1)
        }
    }
    return (
        <JoyRide
            run={run}
            steps={steps}
            continuous={true}
            callback={handleJoyrideCallback}
            hideCloseButton={true}
            showSkipButton={true}
            showProgress={false}
            disableCloseOnEsc
            disableOverlayClose
            spotlightPadding={5}
            styles={{
                options: {
                    zIndex: 10000,
                    overlayColor: "rgba(0,0,0,0.9)",
                },
                tooltipContainer: {
                    textAlign: "left"
                },
                buttonNext: {
                    backgroundColor: "#4285f4"
                },
                buttonBack: {
                    marginRight: 10
                },
                overlay: {
                    border: "1px solid #4285f4"
                },
                spotlight: {
                    border: "1px solid #4285f4"
                },

            }}
        />
    )
}

export default BookingTour