'use client'

import { useEffect, useState } from 'react'
import { RxQuestionMarkCircled } from 'react-icons/rx'
import {
    Sheet,
    SheetContent,
    SheetDescription,
    SheetHeader,
    SheetTitle,
    SheetTrigger,
} from "@/components/ui/sheet"
import {
    Accordion,
    AccordionContent,
    AccordionItem,
    AccordionTrigger,
} from "@/components/ui/accordion"
import { Card } from '@/components/ui/card'
import HelpCard from '@/components/ui/help-card'
import { GoDot, GoDotFill } from 'react-icons/go'
import { LuDot } from 'react-icons/lu'
import { ScrollArea } from '@/components/ui/scroll-area'
import Image from 'next/image'


const Help = () => {

    return (
        <Sheet>
            <SheetTrigger asChild>
                <div className="flex items-center gap-2 cursor-pointer py-2 px-3 hover:bg-stone-200">
                    <RxQuestionMarkCircled className="h-5 w-5"/>
                    <span className="text-sm">Get More Help</span>
                </div>
            </SheetTrigger>
            <SheetContent>
                <SheetHeader>
                    <SheetTitle className='text-center'>HELP</SheetTitle>
                    <SheetDescription className='sr-only'></SheetDescription>
                </SheetHeader>
                <ScrollArea className="h-[90vh] w-full pr-2.5">
                    <Accordion type="single" collapsible className="w-full" defaultValue="overview">
                        <div className='space-y-2 mt-2'>
                            <HelpCard id='overview' title='Overview'>
                                <div className='space-y-2 leading-5 text-base'>
                                    <p>The <strong>Overview</strong> menu provides a comprehensive summary of the villa's financial performance and key metrics for current month based on report. The main sections and data presented include: </p>
                                    <ul className='grid gap-2 list-disc list-inside'>
                                        <li className='flex gap-x-2'>
                                            <div className='shrink mt-1'>
                                                <GoDotFill />
                                            </div>
                                            <div className='grow grid'>
                                                <p className='font-medium'>Net Revenue</p>
                                                <p>The total income generated from all sources before expenses are deducted.</p>
                                            </div>
                                        </li>
                                        <li className='flex gap-x-2'>
                                            <div className='shrink mt-1'>
                                                <GoDotFill />
                                            </div>
                                            <div className='grow grid'>
                                                <p className='font-medium'>Occupancy</p>
                                                <p>The percentage of available units (e.g., rooms, apartments) that are occupied over a given period.</p>
                                            </div>
                                        </li>
                                        <li className='flex gap-x-2'>
                                            <div className='shrink mt-1'>
                                                <GoDotFill />
                                            </div>
                                            <div className='grow grid'>
                                                <p className='font-medium'>Average Daily Rate (ADR)</p>
                                                <p>The average income earned per occupied unit per day.</p>
                                            </div>
                                        </li>
                                        <li className='flex gap-x-2'>
                                            <div className='shrink mt-1'>
                                                <GoDotFill />
                                            </div>
                                            <div className='grow grid'>
                                                <p className='font-medium'>Expenses</p>
                                                <p>The total costs incurred by the business for its operations.</p>
                                            </div>
                                        </li>
                                        <li className='flex gap-x-2'>
                                            <div className='shrink mt-1'>
                                                <GoDotFill />
                                            </div>
                                            <div className='grow grid'>
                                                <p className='font-medium'>Total Revenue</p>
                                                <p>The cumulative income generated over a year.</p>
                                            </div>
                                        </li>
                                        <li className='flex gap-x-2'>
                                            <div className='shrink mt-1'>
                                                <GoDotFill />
                                            </div>
                                            <div className='grow grid'>
                                                <p className='font-medium'>Total Profit</p>
                                                <p>The cumulative income remaining after all expenses have been deducted over a year.</p>
                                            </div>
                                        </li>
                                        <li className='flex gap-x-2'>
                                            <div className='shrink mt-1'>
                                                <GoDotFill />
                                            </div>
                                            <div className='grow grid'>
                                                <p className='font-medium'>Total Expenses</p>
                                                <p>The cumulative costs incurred over a year.</p>
                                            </div>
                                        </li>
                                        <li className='flex gap-x-2'>
                                            <div className='shrink mt-1'>
                                                <GoDotFill />
                                            </div>
                                            <div className='grow grid'>
                                                <p className='font-medium'>Recent Booking</p>
                                                <p>The most current reservation made by a customer.</p>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                            </HelpCard>
                            <HelpCard id='live' title='Live Data'>
                                <div className='space-y-2  text-base'>
                                    <p>A comprehensive <strong>Calendar</strong> that displays all booking data for your villas, providing a clear overview of occupancy and availability. You can click details for each villa get information about monthly data, and its include :</p>
                                    <ul className='grid gap-2 list-disc list-inside'>
                                        <li className='flex gap-x-2'>
                                            <div className='shrink mt-1'>
                                                <GoDotFill />
                                            </div>
                                            <div className='grow grid'>
                                                <p className='font-medium'>Monthly Revenue</p>
                                                <p>The total income generated for the specific month.</p>
                                            </div>
                                        </li>
                                        <li className='flex gap-x-2'>
                                            <div className='shrink mt-1'>
                                                <GoDotFill />
                                            </div>
                                            <div className='grow grid'>
                                                <p className='font-medium'>Average Daily Rate (ADR)</p>
                                                <p>The average rate charged per day for the specific month.</p>
                                            </div>
                                        </li>
                                        <li className='flex gap-x-2'>
                                            <div className='shrink mt-1'>
                                                <GoDotFill />
                                            </div>
                                            <div className='grow grid'>
                                                <p className='font-medium'>Occupancy</p>
                                                <p>The percentage of available units occupied during the specific month.</p>
                                            </div>
                                        </li>
                                        <li className='flex gap-x-2'>
                                            <div className='shrink mt-1'>
                                                <GoDotFill />
                                            </div>
                                            <div className='grow grid'>
                                                <p className='font-medium'>Booking Source</p>
                                                <p>Information on the different platforms or methods through which bookings were made during the specific month.</p>
                                            </div>
                                        </li>
                                        <li className='flex gap-x-2'>
                                            <div className='shrink mt-1'>
                                                <GoDotFill />
                                            </div>
                                            <div className='grow grid'>
                                                <p className='font-medium'>Total Days Booked</p>
                                                <p>The total number of days the villa is booked in the specific month.</p>
                                            </div>
                                        </li>
                                        <li className='flex gap-x-2'>
                                            <div className='shrink mt-1'>
                                                <GoDotFill />
                                            </div>
                                            <div className='grow grid'>
                                                <p className='font-medium'>Yearly Revenue</p>
                                                <p>The total income generated over the year.</p>
                                            </div>
                                        </li>
                                    </ul>
                                    <p>as for <span className='font-medium'>Yearly Data</span> its include ( Total Booking, Total Nights, Total Occupancy )</p>
                                </div>
                            </HelpCard>
                            <HelpCard id='bookings' title='Bookings'>
                                <div className='space-y-2  text-base'>
                                    <p>In the <strong>Booking List</strong>, each booking is accompanied by an icon that indicates the platform or method through which the booking was made. These icons help you quickly identify the source of each booking at a glance. Here are some common icons you might see:</p>
                                    <ul className='grid gap-2 list-disc list-inside'>
                                        <li className='flex gap-x-2'>
                                            <div className='shrink-0 w-[50px] h-[50px]'>
                                                <Image src='/platform/airbnb.png' width={50} height={50} alt="airbnb" />
                                            </div>
                                            <div className='grow grid'>
                                                <p className='font-medium'>Airbnb</p>
                                            </div>
                                        </li>
                                        <li className='flex gap-x-2'>
                                            <div className='shrink-0 w-[50px] h-[50px]'>
                                                <Image src='/platform/booking.png' width={50} height={50} alt="booking.com" />
                                            </div>
                                            <div className='grow grid'>
                                                <p className='font-medium'>Booking.com</p>
                                            </div>
                                        </li>
                                        <li className='flex gap-x-2'>
                                            <div className='shrink-0 w-[50px] h-[50px]'>
                                                <Image src='/platform/agoda.png' width={50} height={50} alt="agoda" />
                                            </div>
                                            <div className='grow grid'>
                                                <p className='font-medium'>Agoda</p>
                                            </div>
                                        </li>
                                        <li className='flex gap-x-2'>
                                            <div className='shrink-0 w-[50px] h-[50px]'>
                                                <Image src='/platform/expedia.png' width={50} height={50} alt="expedia" />
                                            </div>
                                            <div className='grow grid'>
                                                <p className='font-medium'>Expedia</p>
                                            </div>
                                        </li>
                                        <li className='flex gap-x-2'>
                                            <div className='shrink-0 w-[50px] h-[50px]'>
                                                <Image src='/platform/brv.png' width={50} height={50} alt="bali-rental-villa" />
                                            </div>
                                            <div className='grow grid'>
                                                <p className='font-medium'>Bali Rental Villa</p>
                                                <p>This is our own online villa rental platform to accommodate your guests' reservation to your property.</p>
                                            </div>
                                        </li>
                                        <li className='flex gap-x-2'>
                                            <div className='shrink-0 w-[50px] h-[50px]'>
                                                <Image src='/platform/owner-stay.png' width={50} height={50} alt="owner-stay" />
                                            </div>
                                            <div className='grow grid'>
                                                <p className='font-medium'>Owner Stay</p>
                                                <p>This is when you, as an owner, will be staying at your villa.</p>
                                            </div>
                                        </li>
                                        <li className='flex gap-x-2'>
                                            <div className='shrink-0 w-[50px] h-[50px]'>
                                                <Image src='/platform/owner-booking.png' width={50} height={50} alt="owner-booking" />
                                            </div>
                                            <div className='grow grid'>
                                                <p className='font-medium'>Owner Direct Booking</p>
                                                <p>This is a booking made from you, as an owner.</p>
                                            </div>
                                        </li>
                                        <li className='flex gap-x-2'>
                                            <div className='shrink-0 w-[50px] h-[50px]'>
                                                <Image src='/platform/influencer.png' width={50} height={50} alt="influencer" />
                                            </div>
                                            <div className='grow grid'>
                                                <p className='font-medium'>Influencer</p>
                                                <p>These are complimentary stays given to a social media user with established credibility who can promote your property to their loyal followers.</p>
                                            </div>
                                        </li>
                                        <li className='flex gap-x-2'>
                                            <div className='shrink-0 w-[50px] h-[50px]'>
                                                <Image src='/platform/maintenance.png' width={50} height={50} alt="maintenance" />
                                            </div>
                                            <div className='grow grid'>
                                                <p className='font-medium'>Maintenance</p>
                                                <p>This icon indicates when maintenance is scheduled at your villa</p>
                                            </div>
                                        </li>
                                        <li className='flex gap-x-2'>
                                            <div className='shrink-0 w-[50px] h-[50px]'>
                                                <Image src='/platform/direct.png' width={50} height={50} alt="direct" />
                                            </div>
                                            <div className='grow grid'>
                                                <p className='font-medium'>Direct Booking</p>
                                                <p>This is for bookings made directly through us without any platform.</p>
                                            </div>
                                        </li>
                                        <li className='flex gap-x-2'>
                                            <div className='shrink-0 w-[50px] h-[50px]'>
                                                <Image src='/platform/travel-agent.png' width={50} height={50} alt="travel-agent" />
                                            </div>
                                            <div className='grow grid'>
                                                <p className='font-medium'>Offline Agent</p>
                                                <p>This is a booking made from other online villa rental companies who have been verified by our team.</p>
                                            </div>
                                        </li>
                                        <li className='flex gap-x-2'>
                                            <div className='shrink-0 w-[50px] h-[50px]'>
                                                <Image src='/platform/blocked.png' width={50} height={50} alt="blocked" />
                                            </div>
                                            <div className='grow grid'>
                                                <p className='font-medium'>Blocked</p>
                                                <p>This booking is currently on hold.</p>
                                            </div>
                                        </li>
                                        <li className='flex gap-x-2'>
                                            <div className='shrink-0 w-[50px] h-[50px]'>
                                                <Image src='/platform/pend.png' width={50} height={50} alt="pending" />
                                            </div>
                                            <div className='grow grid'>
                                                <p className='font-medium'>Pending Payment</p>
                                                <p>This booking is pending payment from the guests.</p>
                                            </div>
                                        </li>
                                        <li className='flex gap-x-2'>
                                            <div className='shrink-0 w-[50px] h-[50px]'>
                                                <Image src='/platform/prev-management.png' width={50} height={50} alt="prev-management" />
                                            </div>
                                            <div className='grow grid'>
                                                <p className='font-medium'>Previous Management</p>
                                                <p>This icon provides access to information about past management activities at your villa.</p>
                                            </div>
                                        </li>
                                        <li className='flex gap-x-2'>
                                            <div className='shrink-0 w-[50px] h-[50px]'>
                                                <Image src='/platform/web-booking.png' width={50} height={50} alt="web-booking" />
                                            </div>
                                            <div className='grow grid'>
                                                <p className='font-medium'>Website Booking</p>
                                                <p>This is for bookings made from your website.</p>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                            </HelpCard>
                            <HelpCard id='report' title='Financial Report'>
                                <div className='space-y-2  text-base'>
                                    <p>Access comprehensive <strong>Financial Reports</strong> to analyze your villa's performance. View detailed insights on revenue, expenses, occupancy rates, and other key metrics to help you make informed decisions.</p>
                                    <p>On mobile, the reports are available for download</p>
                                </div>
                            </HelpCard>
                            <HelpCard id='profile' title='Profile'>
                                <div className='space-y-2  text-base'>
                                    <p>Manage your account details in the <strong>Profile</strong> Menu. Update your email, password, phone number, and profile image. View and manage your villa listings, and access the list of registered WhatsApp numbers and email addresses for notifications. Easily add, modify, or delete contact information to stay informed.</p>
                                </div>
                            </HelpCard>
                        </div>
                    </Accordion>
                </ScrollArea>
            </SheetContent>
        </Sheet>
    )
}

export default Help