'use client'

import { MdLightbulbOutline } from "react-icons/md";
import { RxQuestionMarkCircled } from 'react-icons/rx'
import {
    Sheet,
    SheetContent,
    SheetDescription,
    SheetHeader,
    SheetTitle,
    SheetTrigger,
} from "@/components/ui/sheet"
import { useEffect, useState } from "react";

const LearnMore = () => {

    return (
        <Sheet>
            <SheetTrigger asChild>
                <div className="flex items-center gap-2 cursor-pointer py-2 px-3 hover:bg-stone-200">
                    <MdLightbulbOutline className="h-5 w-5"/>
                    <span className="text-sm">Learn about this page</span>
                </div>
            </SheetTrigger>
            <SheetContent>
                <SheetHeader>
                <SheetTitle>Are you absolutely sure?</SheetTitle>
                <SheetDescription>
                    This action cannot be undone. This will permanently delete your account
                    and remove your data from our servers.
                </SheetDescription>
                </SheetHeader>
            </SheetContent>
        </Sheet>
    )
}

export default LearnMore