'use client'

import { useEffect, useState } from "react";
import JoyRide, {EVENTS, STATUS} from "react-joyride";
import type { CallBackProps, Step } from "react-joyride";

interface State {
    run: boolean;
    stepIndex: number;
    steps: Step[];
}

interface Props {
    start: any;
    setStartTour: (value: boolean) => void;
    onTourEnd: () => void
}

const ReportTour = ({start, setStartTour, onTourEnd}: Props) => {
    const [progress, setProgress] = useState<number>(1)
    const totalSteps: number = 3;

    const generateSteps = (val: number): Step[] => [
        {
            target: '#report-1',
            content: (
                <div>
                    <p>This section will display your latest available report. For a better experience, please use a laptop or computer so you can view the PDF directly. On mobile, the reports are available for download by clicking 'Download.</p>
                    <div className="absolute bottom-5 right-1/2 text-sm">
                        {val}/{totalSteps}
                    </div>
                </div>
            ),
            locale: {skip: <strong aria-label="skip">Skip</strong>},
            disableBeacon: true,
        },
        {
            target: '#report-2',
            content: (
                <div>
                    <p>Here is your all available reports</p>
                    <div className="absolute bottom-5 right-1/2 text-sm">
                        {val}/{totalSteps}
                    </div>
                </div>
            ),
            locale: {skip: <strong aria-label="skip">Skip</strong>},
        },
        {
            target: '#report-3',
            content: (
                <div>
                    <p>The report will show here, for mobile users the reports are available for download</p>
                    <div className="absolute bottom-5 right-1/2 text-sm">
                        {val}/{totalSteps}
                    </div>
                </div>
            ),
            locale: {skip: <strong aria-label="skip">Skip</strong>, last: <span aria-label="last">Got it</span>},
        },
    ]

    const [{run, steps}, setState] = useState<State>({
        run: start, 
        stepIndex: 0, 
        steps: generateSteps(progress),
    });

    useEffect(() => {
        setState((prevState) => ({
            ...prevState,
            steps: generateSteps(progress),
        }))
    }, [progress])

    useEffect(() => {
        if(start){
            setState((prevState) => ({
                ...prevState,
                run: true,
                stepIndex: 0,
            }))
        }
    }, [start])

    const handleJoyrideCallback = (data: CallBackProps) => {
        const { status, type, index } = data;

        const finishedStatuses: string[] = [STATUS.FINISHED, STATUS.SKIPPED];
        if (finishedStatuses.includes(status)) {
            setState({steps, run: false, stepIndex: 0})
            setStartTour(false)
            onTourEnd()
        }else if (type === EVENTS.STEP_BEFORE) {
            setProgress(index + 1)
        }
    }
    return (
        <JoyRide
            run={run}
            steps={steps}
            continuous={true}
            callback={handleJoyrideCallback}
            hideCloseButton={true}
            showSkipButton={true}
            showProgress={false}
            disableCloseOnEsc
            disableOverlayClose
            spotlightPadding={5}
            styles={{
                options: {
                    zIndex: 10000,
                    overlayColor: "rgba(0,0,0,0.9)",
                },
                tooltipContainer: {
                    textAlign: "left"
                },
                buttonNext: {
                    backgroundColor: "#4285f4"
                },
                buttonBack: {
                    marginRight: 10
                },
                overlay: {
                    border: "1px solid #4285f4"
                },
                spotlight: {
                    border: "1px solid #4285f4"
                },

            }}
        />
    )
}

export default ReportTour