'use client'

import { Button } from "@/components/ui/button"
import { Separator } from "@/components/ui/separator"
import { CgClose } from "react-icons/cg"

interface Props {
    close: (value: boolean) => void
}
const Test = ({close}: Props) => {
    return (
        <div className="absolute bottom-10 right-0 z-[41]">
            <div className="flex flex-col justify-end bg-white border rounded-2xl w-[360px] h-auto p-3">
                <div className="flex items-center">
                    <div className="grow">
                        <p className="text-center">FEEDBACK</p>
                    </div>
                    <div className="shrink border-l m-1">
                        <Button variant='ghost' size='sm' onClick={() => close(false)}>
                            <CgClose className="h-5 w-5"/>
                        </Button>
                    </div>
                </div>
                <Separator />
                <div className="">

                </div>
            </div>
        </div>
    )
}

export default Test