'use client'

import { useParams, usePathname, useRouter, useSearchParams } from "next/navigation";
import Image from "next/image";
import { logout } from "@/actions/auth/logout";

import {
    DropdownMenu,
    DropdownMenuContent,
    DropdownMenuGroup,
    DropdownMenuItem,
    DropdownMenuLabel,
    DropdownMenuPortal,
    DropdownMenuSeparator,
    DropdownMenuSub,
    DropdownMenuSubContent,
    DropdownMenuSubTrigger,
    DropdownMenuTrigger,
} from "@/components/ui/dropdown-menu"
import { Avatar, AvatarFallback, AvatarImage } from "@/components/ui/avatar"  
import { Button } from "@/components/ui/button"
import { Skeleton } from "@/components/ui/skeleton";

import { IoLogOutOutline } from "react-icons/io5";
import Link from "next/link";




interface Props {
    data: any;
    loading: boolean;
    setLoading: (value: boolean) => void;
}
export function UserNav({data, loading, setLoading } : Props) {
    const router = useRouter();
    const params = useParams()

    const onSubmit = async () => {
        setLoading(true)
        const out = await logout()

        if(out?.success){
            router.push("/login");
        }
    }
    return (
        <DropdownMenu>
            <DropdownMenuTrigger asChild>
                {loading ? (
                    <Skeleton className="h-8 w-8 rounded-full" />
                ) : (
                    <Button variant="ghost" id="step-2" className="relative h-8 w-8 rounded-full">
                        <Avatar className="h-8 w-8">
                            <AvatarImage src={data ? data.profile : ''} alt={data ? data.fullname : ''} />
                            <AvatarFallback>SC</AvatarFallback>
                        </Avatar>
                    </Button>
                )}
            </DropdownMenuTrigger>
            <DropdownMenuContent className="w-56" align="end" forceMount>
                <DropdownMenuLabel className="font-normal">
                    <div className="flex flex-col space-y-1">
                    <p className="text-sm font-medium leading-none">{data ? data.fullname : 'Name'}</p>
                    <p className="text-xs leading-none text-muted-foreground">
                        {data? data.email : 'Email'}
                    </p>
                    </div>
                </DropdownMenuLabel>
                <DropdownMenuSeparator />
                <DropdownMenuGroup className="space-y-2">
                    <DropdownMenuSub>
                        <DropdownMenuSubTrigger className="cursor-pointer">
                        {params.locale === "en" && (
                            <Image
                                src="/icons/en.svg"
                                alt="English"
                                width={16}
                                height={16}
                                className="mr-2 h-4 w-4"
                            />
                        )}
                        {params.locale === "fr" && (
                            <Image
                                src="/icons/fr.svg"
                                alt="English"
                                width={16}
                                height={16}
                                className="mr-2 h-4 w-4"
                            />
                        )}
                        {params.locale === "id" && (
                            <Image
                                src="/icons/id.svg"
                                alt="English"
                                width={16}
                                height={16}
                                className="mr-2 h-4 w-4"
                            />
                        )}
                        Language
                        </DropdownMenuSubTrigger>
                        <DropdownMenuPortal>
                            <DropdownMenuSubContent>
                                <DropdownMenuItem className="cursor-pointer" onClick={() => setLoading(true)}>
                                    <Link href="/en" locale="en" className="flex items-center gap-1 w-full">
                                        <Image
                                            src="/icons/en.svg"
                                            alt="English"
                                            width={16}
                                            height={16}
                                            className="mr-2 h-4 w-4"
                                        />
                                        <span>EN</span>
                                    </Link>
                                </DropdownMenuItem>
                                <DropdownMenuItem className="cursor-pointer" onClick={() => setLoading(true)}>
                                    <Link href="/fr" locale="fr"  className="flex items-center gap-1 w-full">
                                        <Image
                                            src="/icons/fr.svg"
                                            alt="French"
                                            width={16}
                                            height={16}
                                            className="mr-2 h-4 w-4"
                                        />
                                        <span>FR</span>
                                    </Link>
                                </DropdownMenuItem>
                                <DropdownMenuItem className="cursor-pointer" onClick={() => setLoading(true)}>
                                    <Link href="/id" locale="id"  className="flex items-center gap-1 w-full">
                                        <Image
                                            src="/icons/id.svg"
                                            alt="Indonesian"
                                            width={16}
                                            height={16}
                                            className="mr-2 h-4 w-4"
                                        />
                                        <span>ID</span>
                                    </Link>
                                </DropdownMenuItem>
                            </DropdownMenuSubContent>
                        </DropdownMenuPortal>
                    </DropdownMenuSub>
                </DropdownMenuGroup>
                <DropdownMenuSeparator />
                <DropdownMenuItem onClick={onSubmit} className="cursor-pointer">
                    <IoLogOutOutline className="mr-2 h-4 w-4" />
                    <span>Sign out</span>
                </DropdownMenuItem>
            </DropdownMenuContent>
        </DropdownMenu>
    )
}