"use client"

import * as React from "react"
import { IoCheckmarkOutline } from "react-icons/io5";
import { MdSort } from "react-icons/md";

import { cn } from "@/lib/utils"
import { Avatar, AvatarFallback, AvatarImage } from "@/components/ui/avatar"
import {
    Command,
    CommandEmpty,
    CommandGroup,
    CommandInput,
    CommandItem,
    CommandList,
} from "@/components/ui/command"
import {
    Popover,
    PopoverContent,
    PopoverTrigger,
} from "@/components/ui/popover"

import { Button } from "@/components/ui/button"

interface Props {
    loading: boolean;
    villa: any;
    selected: any;
    onchange: (data: any) => void;

}

export default function VillaSwitcher({loading, villa, onchange, selected} : Props) {
    const [open, setOpen] = React.useState(false)
    const [value, setValue] = React.useState('')
    return (
        <Popover open={open} onOpenChange={setOpen}>
            <PopoverTrigger asChild>
                <Button
                    id="step-1"
                    variant="outline"
                    role="combobox"
                    aria-expanded={open}
                    aria-label="Select a team"
                    className="w-[300px] justify-between"
                    disabled={loading} 
                >
                    {selected && (
                        <>
                            <Avatar className="mr-2 h-5 w-5">
                                <AvatarImage
                                    src={selected.img}
                                    alt={selected.villa_name}
                                    // className="grayscale"
                                />
                                <AvatarFallback>V</AvatarFallback>
                            </Avatar>
                            {selected.villa_name}
                        </>
                    )}
                    <MdSort className="ml-auto h-4 w-4 shrink-0 opacity-50" />
                </Button>
            </PopoverTrigger>
            <PopoverContent className="lg:w-[300px] w-auto p-0">
                <Command>
                    <CommandList>
                        <CommandGroup>
                            {villa.length > 1 && (
                                <CommandInput placeholder="Search villa..." />
                            )}
                            <CommandEmpty>No villa found.</CommandEmpty>
                            {villa && villa.map((villa: any) => (
                                <CommandItem
                                    key={villa.id}
                                    value={villa.id}
                                    onSelect={(value) => {
                                        setOpen(false);
                                        onchange(villa)
                                        setValue(value)
                                    }}
                                    disabled={loading}
                                    className="text-sm mt-2 cursor-pointer"
                                >
                                    <Avatar className="mr-2 h-5 w-5">
                                        <AvatarImage
                                            src={villa.img}
                                            alt={villa.villa_name}
                                        />
                                        <AvatarFallback>{villa.villa_name}</AvatarFallback>
                                    </Avatar>
                                    {villa.villa_name}
                                    {selected && selected.id === villa.id && (
                                        <IoCheckmarkOutline
                                            className={cn(
                                                "ml-auto h-4 w-4",
                                                selected.id === villa.id
                                                    ? "opacity-100"
                                                    : "opacity-0"
                                            )}
                                        />
                                    )}
                                    
                                </CommandItem>
                            ))}
                        </CommandGroup>
                    </CommandList>
                </Command>
            </PopoverContent>
        </Popover>
    )
}
