'use client'

import { compareAsc, isAfter, parseISO } from "date-fns";

interface Props {
    data: any;
    selected: any;
}
const Test = ({data, selected}: Props) => {

    const filterRelevantDates = (data: any) => {
        const today = new Date();
        return data.filter((item: any) => {
            const startDate = parseISO(item.start);
            const endDate = parseISO(item.end);
            return isAfter(startDate, today) || (today >= startDate && today <= endDate);
        });
    }
    const futureEvents = filterRelevantDates(data);
    const roomData = futureEvents.filter((item: any) => item.resourceId === selected.room_id);
    const sortedData = roomData.sort((a: any, b: any) => compareAsc(parseISO(a.start), parseISO(b.start)));
    return (
        <pre>
            {JSON.stringify(sortedData, null, 2)}
        </pre>
    )
}

export default Test