'use client'

import {
    Popover,
    PopoverContent,
    PopoverTrigger,
} from "@/components/ui/popover"
import { Avatar, AvatarFallback, AvatarImage } from "../ui/avatar";

interface Props {
    icon: string
    name: string
}
const IconPopover = ({icon, name} : Props) => {
    return (
        <Popover>
            <PopoverTrigger>
                <Avatar className="flex-shrink h-10 w-10">
                    <AvatarImage src={icon} alt="Avatar" />
                    <AvatarFallback>{name}</AvatarFallback>
                </Avatar>
            </PopoverTrigger>
            <PopoverContent className="text-sm w-auto">
                {name}
            </PopoverContent>
        </Popover>

    )
}

export default IconPopover