'use client'

import {
    Accordion,
    AccordionContent,
    AccordionItem,
    AccordionTrigger,
} from "@/components/ui/accordion"
import { 
    Card, 
    CardContent, 
    CardDescription, 
    CardHeader, 
    CardTitle 
} from '@/components/ui/card'

interface Props{
    id: any;
    title: string;
    children: React.ReactNode
}
const HelpCard = ({id, title, children}: Props) => {
    return (
        <Card>
            <CardHeader className="sr-only">
                <CardTitle>Card Title</CardTitle>
                <CardDescription>Card Description</CardDescription>
            </CardHeader>
            <CardContent className="p-0 px-3">
                <AccordionItem value={id}>
                    <AccordionTrigger className="font-semibold">{title}</AccordionTrigger>
                    <AccordionContent>
                    {children}
                    </AccordionContent>
                </AccordionItem>
            </CardContent>
        </Card>
    )
}

export default HelpCard