import { NextRequest, NextResponse } from "next/server";
import { auth} from "@/auth";
import createIntlMiddleware from "next-intl/middleware";

const protectedPaths = ['/'];
const apiAuthPrefix = '/api/auth'
const authRoutes = ['/login']

const intlMiddleware = createIntlMiddleware({
    locales: ['en', 'fr', 'id'],
    defaultLocale: "en",
});


export default auth((req: any) => {
    const { nextUrl } = req;
    const isLoggedIn = !!req.auth;  
    const { pathname, search, locale } = req.nextUrl;

    if (req.auth) return intlMiddleware(req);

    // const reqUrl = new URL(req.url);
    // if (!req.auth && reqUrl?.pathname !== "/") {
    //     return NextResponse.redirect(new URL('/', req.url)
    //     );
    // }

    const isApiAuthRoute = nextUrl.pathname.startsWith(apiAuthPrefix);
    const isAuthRoute = authRoutes.includes(nextUrl.pathname);

    if (locale === 'default' && !isApiAuthRoute) {
        const url = new URL(`/${locale}${pathname}${search}`, nextUrl);
        return Response.redirect(url);
    }

    if(isApiAuthRoute){
        const apiUrl = new URL(`/${pathname}${search}`, req.url);
        return Response.redirect(new URL('/', nextUrl));
    }

    if(isAuthRoute){
        if(isLoggedIn){
            return Response.redirect(new URL('/', nextUrl))
        }
        return 
    }

    if(!isLoggedIn ){
        return Response.redirect(new URL('/login', nextUrl))
    }

    return 
})

export const config = {
    matcher: ['/((?!.*\\..*|_next).*)', '/', '/(api|trpc)(.*)']
    //matcher: ['/']
}